/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.error.Err;
import de.mn77.base.sys.Sys;
import de.mn77.base.thread.CycleTimer;
import java.util.TimerTask;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Timer
extends A_Object
implements I_Object {
    private final CycleTimer timer = new CycleTimer();

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "every": {
                return this.every(cr);
            }
            case "wait": {
                return this.wait(cr);
            }
            case "wait2": {
                return this.sleep(cr);
            }
            case "sleep": {
                return this.sleep(cr);
            }
            case "stop": {
                return A_Object.stdResult(this.stop(cr));
            }
        }
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        super.describe(cr, left);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "Random";
    }

    @Override
    public String toString() {
        return "Random";
    }

    private ObjectCallResult every(final CallRuntime cr) {
        Int ms = (Int)cr.pars(JMo_Timer.class, this, Int.class)[0];
        final Call stream = cr.getStream();
        final Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cr, "Wrong call", "No stream, no block, for timer ... what to do?");
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                JMo_Timer.this.syncGo(cr, block, stream);
            }
        };
        this.timer.add(ms.getValue(), task);
        return new ObjectCallResult(this, true);
    }

    private JMo_Timer stop(CallRuntime cr) {
        cr.pars(JMo_Timer.class);
        this.timer.stop();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncGo(CallRuntime cr, Block block, Call stream) {
        JMo_Timer jMo_Timer = this;
        synchronized (jMo_Timer) {
            try {
                if (block != null) {
                    block.exec(cr, null);
                }
                if (stream != null) {
                    cr.execInit(stream, null);
                }
            }
            catch (Throwable t) {
                Err.show(t);
            }
        }
    }

    private ObjectCallResult wait(final CallRuntime cr) {
        Int ms = (Int)cr.pars(JMo_Timer.class, this, Int.class)[0];
        final Call stream = cr.getStream();
        final Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cr, "Wrong call", "No stream, no block, for timer ... what to do?");
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                JMo_Timer.this.syncGo(cr, block, stream);
            }
        };
        this.timer.add(ms.getValue(), 1, task);
        return new ObjectCallResult(this, true);
    }

    private ObjectCallResult sleep(CallRuntime cr) {
        int ms = Lib_Convert.getIntValue(cr, cr.pars(JMo_Timer.class, this, A_IntNumber.class)[0]);
        Sys.sleep(ms);
        return new ObjectCallResult(this, true);
    }
}

