/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.spec.terminal;

public class CSI {
    private static final String ESC = "\u001b[";

    public static String reset() {
        return "\u001b[0";
    }

    public static String cursorLeft(int ... len) {
        return ESC + CSI.par1(len) + "D";
    }

    public static String cursorRight(int ... len) {
        return ESC + CSI.par1(len) + "C";
    }

    public static String cursorUp(int ... len) {
        return ESC + CSI.par1(len) + "A";
    }

    public static String cursorDown(int ... len) {
        return ESC + CSI.par1(len) + "B";
    }

    public static String cursorToRow(int ... row) {
        return ESC + CSI.par1(row) + "G";
    }

    public static String cursorToLine(int ... row) {
        return ESC + CSI.par1(row) + "F";
    }

    public static Object cursorTopLeft() {
        return "\u001b[H";
    }

    public static String eraseLineToEnd(int ... len) {
        return ESC + CSI.par1(len) + "K";
    }

    public static String displayClear() {
        return "\u001b[2J";
    }

    public static String color_bg_Black() {
        return "\u001b[40m";
    }

    public static String color_bg_Red() {
        return "\u001b[41m";
    }

    public static String color_bg_Green() {
        return "\u001b[42m";
    }

    public static String color_bg_Brown() {
        return "\u001b[43m";
    }

    public static String color_bg_Blue() {
        return "\u001b[44m";
    }

    public static String color_bg_Magenta() {
        return "\u001b[45m";
    }

    public static String color_bg_Cyan() {
        return "\u001b[46m";
    }

    public static String color_bg_Gray() {
        return "\u001b[47m";
    }

    public static String color_bg_Default() {
        return "\u001b[49m";
    }

    public static String color_bg_DarkGray() {
        return "\u001b[100m";
    }

    public static String color_bg_LightRed() {
        return "\u001b[101m";
    }

    public static String color_bg_LightGreen() {
        return "\u001b[102m";
    }

    public static String color_bg_Yellow() {
        return "\u001b[103m";
    }

    public static String color_bg_LightBlue() {
        return "\u001b[104m";
    }

    public static String color_bg_LightMagenta() {
        return "\u001b[105m";
    }

    public static String color_bg_Turquise() {
        return "\u001b[106m";
    }

    public static String color_bg_White() {
        return "\u001b[107m";
    }

    public static String color_fg_Black() {
        return "\u001b[30m";
    }

    public static String color_fg_Red() {
        return "\u001b[31m";
    }

    public static String color_fg_Green() {
        return "\u001b[32m";
    }

    public static String color_fg_Brown() {
        return "\u001b[33m";
    }

    public static String color_fg_Blue() {
        return "\u001b[34m";
    }

    public static String color_fg_Magenta() {
        return "\u001b[35m";
    }

    public static String color_fg_Cyan() {
        return "\u001b[36m";
    }

    public static String color_fg_Gray() {
        return "\u001b[37m";
    }

    public static String color_fg_DarkGray() {
        return "\u001b[90m";
    }

    public static String color_fg_LightRed() {
        return "\u001b[91m";
    }

    public static String color_fg_LightGreen() {
        return "\u001b[92m";
    }

    public static String color_fg_Yellow() {
        return "\u001b[93m";
    }

    public static String color_fg_LightBlue() {
        return "\u001b[94m";
    }

    public static String color_fg_LightMagenta() {
        return "\u001b[95m";
    }

    public static String color_fg_Turquise() {
        return "\u001b[96m";
    }

    public static String color_fg_White() {
        return "\u001b[97m";
    }

    public static String color_fg_Default_Underline() {
        return "\u001b[38m";
    }

    public static String color_fg_Default() {
        return "\u001b[39m";
    }

    private static String par1(int[] ia) {
        return ia.length == 1 ? "" + ia[0] : "";
    }
}

