/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.group.Group3;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.error.Err;
import de.mn77.base.version.A_VersionDataExt;
import de.mn77.base.version.VERSIONTYPE;
import de.mn77.base.version.VersionFormatter;

public class VersionData_ABC
extends A_VersionDataExt {
    private Integer medium;
    private final int pre;

    public VersionData_ABC(int big, int medium, int small) {
        super(big, VERSIONTYPE.RELEASE, small);
        this.medium = medium;
        this.pre = 0;
    }

    public VersionData_ABC(int big, int medium, int small, int pre) {
        super(big, VERSIONTYPE.RELEASE, small);
        this.medium = medium;
        this.pre = pre;
    }

    public VersionData_ABC(int big, int medium, int small, int pre, Long build, I_DateTime zeit) {
        this(big, medium, small, pre);
        this.update(build, zeit);
        throw Err.todo("!!! Testen !!!");
    }

    public VersionData_ABC(I_DateTime time, Long build, String[] sa) {
        super(time, build, sa);
        this.medium = Integer.parseInt(sa[1]);
        this.pre = Integer.parseInt(sa[2]);
    }

    protected Integer getMedium() {
        return this.medium;
    }

    protected int getPre() {
        return this.pre;
    }

    @Override
    public String toString() {
        return this.iToString(true);
    }

    public String toString_BuildDate() {
        return this.getBuild() + " - " + this.getTime().getDate();
    }

    public String toString_Short() {
        return this.iToString(false);
    }

    public String toString_Dots() {
        return this.iToString(true);
    }

    @Override
    public String toFormat(String format) {
        return new VersionFormatter().format(this, format);
    }

    @Override
    public Object[] toFileData() {
        return new Object[]{this.getNr(), this.medium, this.getFixnr(), this.pre};
    }

    @Override
    public char getDataSign() {
        return 'b';
    }

    @Override
    protected Group3<Integer, VERSIONTYPE, Integer> update(String[] sa) {
        this.medium = Integer.parseInt(sa[1]);
        return new Group3<Integer, VERSIONTYPE, Integer>(Integer.parseInt(sa[0]), VERSIONTYPE.RELEASE, Integer.parseInt(sa[2]));
    }

    private String iToString(boolean withBuild) {
        return this.getNr() + "." + this.medium + (this.getFixnr() == 0 ? "" : "." + this.getFixnr()) + (withBuild ? " (Build: " + this.getBuild() + " - " + this.getTime() + ")" : "");
    }
}

