/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.convert.ConvText;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import java.io.File;
import java.io.RandomAccessFile;

public class Lib_TextFile {
    public static I_List<String> readLines(File file, boolean utf) throws Err_FileSys {
        if (utf) {
            String text = Lib_TextFile.read(file, true);
            return ConvText.toList("\n", text);
        }
        MList<String> result = new MList<String>();
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "r");
                while (raf.getFilePointer() < raf.length()) {
                    String zeile = raf.readLine();
                    result.add(zeile);
                }
            }
            catch (Exception err) {
                throw Err.fsAccess(err);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
        return result;
    }

    public static I_List<String> readWords(I_File file, char[] delimiters) throws Err_FileSys {
        MList<String> result = new MList<String>();
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file.getFile(), "r");
                String word = "";
                while (raf.getFilePointer() < raf.length()) {
                    char c = (char)raf.readByte();
                    boolean isDelimiter = false;
                    char[] cArray = delimiters;
                    int n = delimiters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char tr = cArray[n2];
                        if (tr == c) {
                            isDelimiter = true;
                            break;
                        }
                        ++n2;
                    }
                    if (isDelimiter) {
                        result.add(word);
                        word = "";
                        continue;
                    }
                    word = String.valueOf(word) + c;
                }
                if (word.length() > 0) {
                    result.add(word);
                }
            }
            catch (Exception err) {
                throw Err.fsAccess(err);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
        return result;
    }

    public static void addRow(I_File file, String s) throws Err_FileSys {
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file.getFile(), "rw");
                raf.seek(raf.length());
                raf.writeBytes(String.valueOf(s) + "\n");
            }
            catch (Exception err) {
                throw Err.fsAccess(err);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File file, boolean utf) throws Err_FileSys {
        Err.ifNull(file);
        StringBuilder sb = new StringBuilder();
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "r");
                if (utf) {
                    byte[] btr = new byte[(int)raf.length()];
                    raf.readFully(btr);
                    String s = new String(btr, "UTF-8");
                    sb.append(s);
                    return sb.toString();
                }
                while (true) {
                    if (raf.getFilePointer() >= raf.length()) {
                        return sb.toString();
                    }
                    sb.append((char)raf.readByte());
                }
            }
            catch (Exception err) {
                throw Err.fsAccess(err);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    public static void set(File file, String s, boolean utf) throws Err_FileSys {
        Lib_TextFile.set(file, null, s, utf);
    }

    public static void set(File file, Long index_pos, String s, boolean utf) throws Err_FileSys {
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                if (index_pos == null) {
                    raf.setLength(0L);
                } else {
                    raf.seek(index_pos);
                }
                if (utf) {
                    raf.write(s.getBytes("UTF-8"));
                } else {
                    raf.writeBytes(s);
                }
            }
            catch (Exception err) {
                throw Err.fsAccess(err, file, s);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    public static void set(File file, I_Sequence<String> lines, boolean utf) throws Err_FileSys {
        StringBuilder sb = new StringBuilder();
        lines.forEach(s -> {
            StringBuilder stringBuilder2 = sb.append(String.valueOf(s) + "\n");
        });
        sb.deleteCharAt(sb.length() - 1);
        Lib_TextFile.set(file, sb.toString(), utf);
    }

    public static void append(File file, String s, boolean utf) throws Err_FileSys {
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(raf.length());
                if (utf) {
                    raf.write(s.getBytes("UTF-8"));
                } else {
                    raf.writeBytes(s);
                }
            }
            catch (Exception err) {
                throw Err.fsAccess(err, file, s);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }
}

