/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table.type;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.I_ListSet;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.data.struct.table.type.I_TypeTable;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.Iterator;

public abstract class A_TypTabelle<TG, TART extends I_ListSet<?>>
implements I_TypeTable<TG, TART> {
    private static final String ERR_ADD_WIDTH = "Count of items don't fit to the width of the table";
    private final Class<?>[] classes;

    protected A_TypTabelle(Class<?> ... classes) {
        this.classes = classes;
    }

    @Override
    public abstract int getWidth();

    @Override
    public abstract TG getRow(int var1);

    @Override
    public abstract TART getCol(int var1);

    @Override
    public abstract <T> TART getCol(int var1, Class<T> var2);

    protected abstract TART getColDirect(int var1);

    @Override
    public Object get(int col, int row) {
        return this.getCol(col).get(row);
    }

    @Override
    public TG get(int row) {
        return this.getRow(row);
    }

    @Override
    public Iterator<TG> iterator() {
        final A_TypTabelle table = this;
        return new Iterator<TG>(){
            private int nextRow = 1;

            @Override
            public boolean hasNext() {
                return this.nextRow <= table.size();
            }

            @Override
            public TG next() {
                Err.ifToBig(table.size(), this.nextRow);
                return table.getRow(this.nextRow++);
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }

    @Override
    public void describe() {
        MOut.debugVersetzt(1, this.toStringDebug());
    }

    @Override
    public String toStringDebug() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        int[] width = new int[this.getWidth()];
        int i = 0;
        while (i < this.getWidth()) {
            for (Object o : this.getCol(i + 1)) {
                int osl = ConvObject.toTextDebug(o).length();
                if (osl <= width[i]) continue;
                width[i] = osl;
            }
            ++i;
        }
        int y = 1;
        while (y <= this.size()) {
            sb.append("| ");
            int x = 1;
            while (x <= this.getWidth()) {
                if (x > 1) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(width[x - 1], ConvObject.toTextDebug(this.get(x, y)), false));
                ++x;
            }
            sb.append(" |");
            if (y != this.size()) {
                sb.append("\n");
            }
            ++y;
        }
        return sb.toString();
    }

    @Override
    public I_TypeTable<TG, TART> copy() {
        throw Err.todo(new Object[0]);
    }

    @Override
    public int size() {
        return this.getCol(1).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void set(int col, int row, Object object) {
        Err.ifOutOfBounds(1.0, this.size(), row);
        Err.ifOutOfBounds(1.0, this.getWidth(), col);
        this.isValid(col, object);
        this.pSet(col, row, object);
    }

    @Override
    public void replace(int row, Object ... objects) {
        Err.ifOutOfBounds(row, this.size());
        Err.ifEqual(row, 0);
        int s = 1;
        while (s <= this.getWidth()) {
            this.isValid(s, objects[s - 1]);
            ++s;
        }
        this.pReplace(row, objects);
    }

    @Override
    public void exchange(int row_a, int row_b) {
        Err.ifEqual(row_a, 0);
        Err.ifEqual(row_b, 0);
        Err.ifOutOfBounds(1.0, this.size(), Math.abs(row_a));
        Err.ifOutOfBounds(1.0, this.size(), Math.abs(row_b));
        if (row_a == row_b) {
            MOut.warnung("Exchange of " + row_a + " and " + row_b + " not necessary!");
            return;
        }
        this.pExchange(row_a, row_b);
    }

    @Override
    public void add(Object ... row) {
        Err.ifNot(this.getWidth(), row.length, ERR_ADD_WIDTH);
        int i = 1;
        while (i <= this.getWidth()) {
            this.isValid(i, row[i - 1]);
            ++i;
        }
        this.pAdd(row);
    }

    @Override
    public void insert(int row, Object ... objects) {
        Err.ifNot(this.getWidth(), objects.length, ERR_ADD_WIDTH);
        Err.ifEqual(row, 0);
        int i = 1;
        while (i <= this.getWidth()) {
            this.isValid(i, objects[i - 1]);
            ++i;
        }
        this.pInsert(row, objects);
    }

    @Override
    public TG remove(int pos) {
        TG row = this.getRow(pos);
        this.pRemove(pos);
        return row;
    }

    @Override
    public TG removeLast() {
        int size = this.size();
        TG row = this.getRow(size);
        this.pRemove(size);
        return row;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int row = 1;
        while (row <= this.size()) {
            int col = 1;
            while (col <= this.getWidth()) {
                sb.append(this.get(col, row) + (col != this.getWidth() ? "," : ""));
                ++col;
            }
            sb.append("\n");
            ++row;
        }
        return sb.toString();
    }

    @Override
    public void sort(int ... columnOrder) {
        Sort.sort(this, columnOrder);
    }

    @Override
    public void sortRandom() {
        Sort.random(this);
    }

    @Override
    public void sortLike(int[] like) {
        int col = 1;
        while (col <= this.getWidth()) {
            this.getColDirect(col).sortLike(like);
            ++col;
        }
    }

    protected abstract void pAdd(Object[] var1);

    protected abstract void pInsert(int var1, Object[] var2);

    protected abstract void pReplace(int var1, Object[] var2);

    protected abstract void pExchange(int var1, int var2);

    protected abstract void pSet(int var1, int var2, Object var3);

    protected abstract void pRemove(int var1);

    protected void isValid(int col, Object o) {
        if (o != null && !this.classes[col - 1].isAssignableFrom(o.getClass())) {
            Err.invalid(o);
        }
    }
}

