/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.keymap;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.I_ListSet;
import de.mn77.base.data.struct.keymap.I_Key_LS;
import de.mn77.base.data.struct.set.I_Set;
import de.mn77.base.data.struct.set.MSet;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.Iterator;

public abstract class A_Key_LS<TA, TB>
implements I_Key_LS<TA, TB> {
    protected I_ListSet<TB> objects;
    private final I_Set<TA> keys = new MSet<TA>();
    protected boolean protection = false;

    @Override
    public void sort(int ... colPars) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        Sort.sort(this, colPars);
    }

    @Override
    public void changeKey(TA key_old, TA key_new) {
        int pos = this.keys.searchPosition(key_old);
        this.keys.set(pos, key_new);
    }

    @Override
    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public int getWidth() {
        return 2;
    }

    @Override
    public I_Set<TA> getKeys() {
        return (I_Set)this.keys.copy();
    }

    @Override
    public Object get(int col, int row) {
        Err.ifOutOfBounds(1.0, 2.0, col);
        if (col == 1) {
            return this.keys.get(row);
        }
        return this.objects.get(row);
    }

    @Override
    public TB get(TA key) {
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            Err.invalid("Unknown key: " + key);
        }
        return (TB)this.objects.get(pos);
    }

    @Override
    public TB get(TA key, TB ifMissing) {
        Integer pos = this.keys.searchPosition(key);
        return (TB)(pos == null ? ifMissing : this.objects.get(pos));
    }

    @Override
    public Group2<TA, TB> get(int row) {
        return new Group2(this.keys.get(row), this.objects.get(row));
    }

    @Override
    public Iterator<Group2<TA, TB>> iterator() {
        return new Iterator<Group2<TA, TB>>(){
            int next = 1;

            @Override
            public boolean hasNext() {
                return A_Key_LS.this.size() >= this.next;
            }

            @Override
            public Group2<TA, TB> next() {
                return new Group2(A_Key_LS.this.keys.get(this.next), A_Key_LS.this.objects.get(this.next++));
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }

    @Override
    public void add(TA key, TB object) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        if (this.keys.contains(key)) {
            Err.invalid("Key is already known: " + key);
        }
        this.keys.add(key);
        this.objects.add(object);
    }

    @Override
    public TB remove(TA key) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            Err.invalid("Unknown key: " + key);
        }
        this.keys.remove(pos);
        Object result = this.objects.get(pos);
        this.objects.remove(pos);
        return (TB)result;
    }

    @Override
    public void replace(TA key, TB newObject) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            Err.invalid("Unknown key: " + key);
        }
        this.objects.set(pos, newObject);
    }

    @Override
    public void set(TA key, TB object) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            this.add(key, object);
        } else {
            this.replace(key, object);
        }
    }

    @Override
    public void exchange(int pos_a, int pos_b) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        this.keys.exchange(pos_a, pos_b);
        this.objects.exchange(pos_a, pos_b);
    }

    @Override
    public void sortLike(int[] so) {
        if (this.protection) {
            throw Err.accessProtected(new Object[0]);
        }
        this.objects.sortLike(so);
        this.keys.sortLike(so);
    }

    @Override
    public void sortRandom() {
        Err.todo("Test");
        Sort.random(this);
    }

    @Override
    public void describe() {
        MOut.debugVersetzt(1, this);
    }

    @Override
    public String toStringDebug() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int z = 1;
        while (z <= this.size()) {
            sb.append(String.valueOf(ConvObject.toTextDebug(this.get(1, z))) + "," + ConvObject.toTextDebug(this.get(2, z)) + "\n");
            ++z;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public void protect() {
        this.protection = true;
    }

    @Override
    public boolean isProtected() {
        return this.protection;
    }
}

