/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing;

import de.mn77.base.data.group.Group3;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jmo_lang.demo.swing.MainPanel;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class JMoSwingDemo {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> JMoSwingDemo.createAndShowGUI());
    }

    private static void createAndShowGUI() {
        Parser_App parser = new Parser_App();
        String version = "JM\u00b0  " + parser.getVersionString(false, true);
        JFrame frame = new JFrame(version);
        frame.setDefaultCloseOperation(3);
        MainPanel panel = new MainPanel(g -> JMoSwingDemo.execute(parser, (Group3<String, JTextArea, JTextField>)g));
        frame.add(panel);
        frame.pack();
        frame.setSize(800, 400);
        frame.setVisible(true);
    }

    private static void execute(Parser_App parser, Group3<String, JTextArea, JTextField> g) {
        String sourcecode = (String)g.o1;
        try {
            App app = parser.parseText(sourcecode);
            app.setOutputBuffer();
            String result = app.exec(null);
            ((JTextField)g.o3).setText(result);
            String text = app.getOutput();
            ((JTextArea)g.o2).setText(text);
        }
        catch (Err_FileSys e) {
            Err.exit((Throwable)e);
        }
        catch (ErrorBaseDebug ce) {
            ((JTextArea)g.o2).setText(ce.toInfo());
        }
    }
}

