/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Java;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.MultiCall;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Table;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_Type;

public class Lib_Convert {
    public static boolean getBoolValue(CallRuntime cr, I_Object o) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof Bool) {
            return ((Bool)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Boolean)((I_AtomicValue)o).convertTo(cr, ATOMIC.BOOL).getValue();
        }
        throw new ExecError(cr, "Wrong type", o.toDebug(cr));
    }

    public static char getCharValue(CallRuntime cr, I_Object o) {
        return Lib_Convert.getCharValue(cr, o, false);
    }

    public static char getCharValue(CallRuntime cr, I_Object o, boolean cut) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof Char) {
            return ((Char)o).getValue().charValue();
        }
        if (o instanceof Bool) {
            return ((Bool)o).getValue() != false ? (char)'1' : '0';
        }
        if (o instanceof I_AtomicValue) {
            if (cut) {
                return ((I_AtomicValue)o).getValue().toString().charAt(0);
            }
            return ((Character)((I_AtomicValue)o).convertTo(cr, ATOMIC.CHAR).getValue()).charValue();
        }
        throw new ExecError(cr, "Wrong type", o.toDebug(cr));
    }

    public static double getDoubleValue(CallRuntime cr, I_Object o) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof Dec) {
            return Lib_Math.normalize(((Dec)o).getValue(), 10);
        }
        if (o instanceof I_AtomicValue) {
            return Lib_Math.normalize((Double)((I_AtomicValue)o).convertTo(cr, ATOMIC.DEC).getValue(), 10);
        }
        throw new ExecError(cr, "Wrong type", o.toDebug(cr));
    }

    public static byte getByteValue(CallRuntime cr, I_Object o) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof JMo_Byte) {
            return ((JMo_Byte)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Byte)((I_AtomicValue)o).convertTo(cr, ATOMIC.BYTE).getValue();
        }
        throw new ExecError(cr, "Wrong type", o.toDebug(cr));
    }

    public static int getIntValue(CallRuntime cr, I_Object o) {
        return Lib_Convert.getIntValue(cr, o, false);
    }

    public static int getIntValue(CallRuntime cr, I_Object o, boolean ord) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof Int) {
            return ((Int)o).getValue();
        }
        if (ord && o instanceof Char) {
            return ((Char)o).getValue().charValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Integer)((I_AtomicValue)o).convertTo(cr, ATOMIC.INT).getValue();
        }
        throw new ExecError(cr, "Wrong type", o.toDebug(cr));
    }

    public static long getLongValue(CallRuntime cr, I_Object o) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof JMo_Long) {
            return ((JMo_Long)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Long)((I_AtomicValue)o).convertTo(cr, ATOMIC.LONG).getValue();
        }
        throw new ExecError(cr, "Wrong type", o.toDebug(cr));
    }

    public static String getStringValue(CallRuntime cr, I_Object o) {
        if ((o = Lib_Convert.getValue(cr, o)) instanceof Str) {
            return ((Str)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return "" + ((I_AtomicValue)o).convertTo(cr, ATOMIC.STR).getValue();
        }
        return o.toString();
    }

    public static I_Object getValue(CallRuntime cr, I_Object o) {
        Err.ifNull(o);
        o.initOnce(cr);
        if (o instanceof Var) {
            return ((Var)o).get(cr);
        }
        if (o instanceof Const) {
            return ((Const)o).get(cr);
        }
        if (o instanceof MultiCall) {
            return ((MultiCall)o).getCurrent();
        }
        return o;
    }

    public static JMo_List toJMo_VarArgs(I_Object ... oa) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            al.add(o);
            ++n2;
        }
        return new JMo_List(al);
    }

    public static JMo_List toJMo(I_Sequence<String> list) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (String s : list) {
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    public static JMo_Table toJMo(I_Table<String> tab) {
        MTable<I_Object> jt = new MTable<I_Object>(tab.getWidth());
        for (I_Sequence i_Sequence : tab) {
            jt.add((I_Sequence<I_Object>)new MList<I_Object>((Collection<I_Object>)Lib_Convert.toJMo(i_Sequence).getInternalObject()));
        }
        return new JMo_Table(jt);
    }

    public static I_List<String> toListString(I_Sequence<I_Object> list) {
        MList<String> res = new MList<String>();
        for (I_Object s : list) {
            res.add(Lib_Convert.getStringValue(null, s));
        }
        return res;
    }

    public static I_Object toJMo(CallRuntime cr, Object o, boolean strict) {
        if (o == null) {
            return Nil.NIL;
        }
        Class<?> cls = o.getClass();
        if (cls == String.class) {
            return new Str((String)o);
        }
        if (cls == Boolean.class) {
            return (Boolean)o != false ? Bool.TRUE : Bool.FALSE;
        }
        if (cls == Character.class) {
            return new Char(((Character)o).charValue());
        }
        if (cls == Byte.class) {
            return new JMo_Byte((Byte)o);
        }
        if (cls == Short.class) {
            return new JMo_Short((Short)o);
        }
        if (cls == Integer.class) {
            return new Int((Integer)o);
        }
        if (cls == Long.class) {
            return new JMo_Long((Long)o);
        }
        if (cls == Float.class) {
            return new JMo_Float(((Float)o).floatValue());
        }
        if (cls == Double.class) {
            return new Dec((Double)o);
        }
        if (!strict) {
            try {
                if (cls == BigDecimal.class) {
                    return new Dec(((BigDecimal)o).doubleValue());
                }
                if (cls == BigInteger.class) {
                    return new Int(((BigInteger)o).intValueExact());
                }
            }
            catch (ArithmeticException e) {
                throw new ExecError(cr, "Value out of bounds", e.getMessage());
            }
        }
        return new JMo_Java(o);
    }

    public static String toString(Call c) {
        if (c == null) {
            return Nil.NIL.toString();
        }
        return c.toString();
    }

    public static I_Table<String> toTableString(JMo_Table tab) {
        MTable<String> res = new MTable<String>(tab.getInternalObject().getWidth());
        for (I_Sequence i_Sequence : tab.getInternalObject()) {
            res.add((I_Sequence<String>)Lib_Convert.toListString(i_Sequence));
        }
        return res;
    }

    public static String typelistToText(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int pos = 0;
        while (pos < types.length) {
            Class<?> c = types[pos];
            if (pos != 0) {
                sb.append(", ");
            }
            sb.append(Lib_Type.getName(c, null));
            ++pos;
        }
        sb.append(")");
        return sb.toString();
    }
}

