/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_MapItem;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Map
extends A_Object
implements I_AutoBlockDo {
    private final ArrayList<I_Object> keys;
    private final ArrayList<I_Object> values;

    public JMo_Map() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public JMo_Map(ArrayList<I_Object> keys, ArrayList<I_Object> objects) {
        this.keys = keys;
        this.values = objects;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "remove": 
            case "sub": {
                return A_Object.stdResult(this.remove(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "copy": {
                return A_Object.stdResult(this.copy(cr));
            }
            case "getLen": 
            case "getSize": 
            case "getLength": {
                return A_Object.stdResult(this.size(cr));
            }
            case "get": {
                return A_Object.stdResult(this.get(cr));
            }
            case "set": {
                return A_Object.stdResult(this.set(cr));
            }
            case "put": {
                return A_Object.stdResult(this.put(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "isEmpty": {
                return A_Object.stdResult(this.isEmpty(cr));
            }
            case "getKeys": {
                return A_Object.stdResult(this.getKeys(cr));
            }
            case "getValues": {
                return A_Object.stdResult(this.getValues(cr));
            }
            case "hasKey": 
            case "knowsKey": {
                return A_Object.stdResult(this.knowsKey(cr));
            }
            case "hasValue": 
            case "knowsValue": {
                return A_Object.stdResult(this.knowsValue(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    public I_Table<I_Object> internalTable() {
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int i = 0;
        while (i < this.keys.size()) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        return tab;
    }

    private ObjectCallResult each(CallRuntime cpOld) {
        JMo_MapItem item;
        boolean varlet;
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        boolean bl = varlet = pars.length == 1;
        if (varlet) {
            cpOld.parType(pars[0], VarLet.class);
        }
        Call stream = cpOld.getStream();
        Block block = cpOld.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'each'", null);
        }
        CallRuntime cpNew = cpOld.copyLoop(new Handle_Loop(this));
        I_Object res = this;
        int pos = 0;
        while (pos < this.keys.size()) {
            block13: {
                item = new JMo_MapItem(this.keys.get(pos), this.values.get(pos));
                if (varlet) {
                    Var o = ((VarLet)pars[0]).getVar();
                    o.let(cpNew, cpNew, item);
                }
                if (block != null) {
                    try {
                        res = block.exec(cpNew, item);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        switch (temp.getLevel()) {
                            case CONTINUE: {
                                break block13;
                            }
                            default: {
                                return temp.getLoopResult();
                            }
                        }
                    }
                }
                if (stream != null && block == null) {
                    res = cpNew.execInit(stream, item);
                }
            }
            ++pos;
        }
        if (stream != null && block != null) {
            if (this.keys.size() == 0) {
                Err.todo("Map is empty!");
            }
            int last = this.keys.size() - 1;
            item = new JMo_MapItem(this.keys.get(last), this.values.get(last));
            res = cpNew.execInit(stream, item);
        }
        return new ObjectCallResult(res, true);
    }

    public Int size(CallRuntime cr) {
        cr.pars(Int.class);
        return new Int(this.keys.size());
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Map(");
        int i = 0;
        while (i < this.keys.size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.keys.get(i).toString());
            sb.append("=>");
            sb.append(this.values.get(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private JMo_Map add(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_Map.class, this, I_Object.class, I_Object.class);
        this.iAdd(cr, oa[0], oa[1]);
        return this;
    }

    private JMo_Map copy(CallRuntime cr) {
        cr.pars(JMo_Map.class, this, new Class[0]);
        ArrayList clonek = (ArrayList)this.keys.clone();
        ArrayList cloneo = (ArrayList)this.values.clone();
        return new JMo_Map(clonek, cloneo);
    }

    private I_Object get(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(null, this, 1, Integer.MAX_VALUE);
        if (oa.length == 1) {
            I_Object key = oa[0];
            int i = this.iGetPosition(cr, key, true);
            return this.values.get(i);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object key = i_ObjectArray[n2];
            int i = this.iGetPosition(cr, key, true);
            I_Object g = this.values.get(i);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private JMo_List getKeys(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        ArrayList clone = (ArrayList)this.keys.clone();
        return new JMo_List(clone);
    }

    private JMo_List getValues(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        ArrayList clone = (ArrayList)this.values.clone();
        return new JMo_List(clone);
    }

    private Bool isEmpty(CallRuntime cr) {
        cr.pars(Bool.class);
        return Bool.getObject(this.keys.size() == 0);
    }

    private Bool knowsKey(CallRuntime cr) {
        I_Object search = cr.pars(Bool.class, this, I_Object.class)[0];
        int knows = this.iGetPosition(cr, search, false);
        return knows == -1 ? Bool.FALSE : Bool.TRUE;
    }

    private Bool knowsValue(CallRuntime cr) {
        I_Object search = cr.pars(Bool.class, this, I_Object.class)[0];
        for (I_Object o : this.values) {
            if (!o.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private JMo_Map remove(CallRuntime cr) {
        I_Object key = cr.pars(JMo_Map.class, this, I_Object.class)[0];
        int i = this.iGetPosition(cr, key, true);
        this.keys.remove(i);
        this.values.remove(i);
        return this;
    }

    private JMo_Map clear(CallRuntime cr) {
        cr.pars(JMo_Map.class, this, new Class[0]);
        this.keys.clear();
        this.values.clear();
        return this;
    }

    private JMo_Map set(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_Map.class, this, I_Object.class, I_Object.class);
        I_Object key = oa[0];
        I_Object value = oa[1];
        int i = this.iGetPosition(cr, key, true);
        this.values.set(i, value);
        return this;
    }

    private JMo_Map put(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_Map.class, this, I_Object.class, I_Object.class);
        int pos = this.iGetPosition(cr, oa[0], false);
        if (pos >= 0) {
            this.values.set(pos, oa[1]);
        } else {
            this.iAdd(cr, oa[0], oa[1]);
        }
        return this;
    }

    private void iAdd(CallRuntime cr, I_Object key, I_Object value) {
        int i = this.iGetPosition(cr, key, false);
        if (i != -1) {
            throw new ExecError(cr, "Duplicated Key", "Got: " + key);
        }
        this.keys.add(key);
        this.values.add(value);
    }

    private int iGetPosition(CallRuntime cr, I_Object key, boolean error) {
        int i = 0;
        while (i < this.keys.size()) {
            boolean equal = this.keys.get(i).equals(key);
            if (equal) {
                return i;
            }
            ++i;
        }
        if (error) {
            throw new ExecError(cr, "Unknown key", "Got: " + key);
        }
        return -1;
    }
}

