/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Sequence;
import org.jmo_lang.tools.Lib_StrFormat;
import org.jmo_lang.tools.Lib_Type;

public class JMo_List
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private ArrayList<I_Object> list;
    private Call[] init;
    private boolean fixedLength = false;
    private boolean fixedTypes = false;

    public JMo_List() {
        this.list = new ArrayList();
        this.init = null;
    }

    public JMo_List(ArrayList<I_Object> list) {
        this.list = list;
        this.init = null;
    }

    public JMo_List(Call ... ca) {
        this.list = null;
        this.init = ca;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init != null) {
            this.list = new ArrayList();
            Call[] callArray = this.init;
            int n = this.init.length;
            int n2 = 0;
            while (n2 < n) {
                Call ca = callArray[n2];
                I_Object o = cr.execInit(ca, null);
                o = Lib_Convert.getValue(cr, o);
                this.list.add(o);
                ++n2;
            }
            this.init = null;
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": 
            case "join": {
                return A_Object.stdResult(this.add(cr));
            }
            case "delete": 
            case "-": {
                return A_Object.stdResult(this.removePos(cr));
            }
            case "remove": 
            case "--": {
                return A_Object.stdResult(this.removeItems(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.insert(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "swap": {
                return A_Object.stdResult(this.swap(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.concat(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.addAll(cr));
            }
            case "shuffle": {
                return A_Object.stdResult(this.shuffle(cr));
            }
            case "reverse": {
                return A_Object.stdResult(this.reverse(cr));
            }
            case "uniq": {
                return A_Object.stdResult(this.uniq(cr));
            }
            case "only": {
                return A_Object.stdResult(this.only(cr));
            }
            case "has": 
            case "knows": {
                return A_Object.stdResult(this.knows(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.search(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.search(cr, false));
            }
            case "each": {
                return this.each(cr);
            }
            case "eachVertical": {
                return this.eachVertical(cr);
            }
            case "combine": 
            case "implode": {
                return A_Object.stdResult(this.implode(cr));
            }
            case "unfold": {
                return A_Object.stdResult(this.unfold(cr));
            }
            case "format": {
                return A_Object.stdResult(this.format(cr));
            }
            case "min": {
                return A_Object.stdResult(this.min(cr));
            }
            case "max": {
                return A_Object.stdResult(this.max(cr));
            }
            case "sum": {
                return A_Object.stdResult(this.sum(cr));
            }
            case "average": 
            case "avg": {
                return A_Object.stdResult(this.average(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.cut(cr));
            }
            case "area": {
                return A_Object.stdResult(this.area(cr));
            }
            case "to": {
                return A_Object.stdResult(this.to(cr));
            }
            case "left": {
                return A_Object.stdResult(this.left(cr));
            }
            case "right": {
                return A_Object.stdResult(this.right(cr));
            }
            case "from": {
                return A_Object.stdResult(this.from(cr));
            }
            case "filter": {
                return A_Object.stdResult(this.filter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.map(cr, method));
            }
            case "sort": {
                return A_Object.stdResult(this.sort(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.reduce(cr, method));
            }
            case "fixLength": {
                cr.pars(JMo_List.class, this, new Class[0]);
                this.fixedLength = true;
                return A_Object.stdResult(this);
            }
            case "fixTypes": {
                cr.pars(JMo_List.class, this, new Class[0]);
                this.fixedTypes = true;
                return A_Object.stdResult(this);
            }
            case "store": {
                return A_Object.stdResult(this.store(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        return this.list;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    public ArrayList<I_Object> getInternalObject() {
        return this.list;
    }

    public void internalAdd(I_Object o) {
        if (this.fixedLength) {
            Err.forbidden(o);
        }
        this.list.add(o);
    }

    public Bool knows(CallRuntime cr) {
        I_Object o = cr.pars(Bool.class, this, I_Object.class)[0];
        for (I_Object lo : this.list) {
            if (!lo.equals(o)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public I_Atomic search(CallRuntime cr, boolean first) {
        I_Object o = cr.pars(Bool.class, this, I_Object.class)[0];
        if (first) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.get(i).compareTo(o) == 0) {
                    return new Int(i + 1);
                }
                ++i;
            }
        } else {
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).compareTo(o) == 0) {
                    return new Int(i + 1);
                }
                --i;
            }
        }
        return Nil.NIL;
    }

    @Override
    public Int size(CallRuntime cr) {
        cr.pars(Int.class);
        return new Int(this.list.size());
    }

    @Override
    public String toDebug(CallRuntime cr) {
        String s = this.list == null ? "null" : Lib_Output.toString(this.list, true);
        return "List(" + s + ")";
    }

    @Override
    public String toString() {
        String s = this.list == null ? "null" : Lib_Output.toString(this.list, true);
        return "[" + s + "]";
    }

    private JMo_List add(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(JMo_List.class, this, 1, Integer.MAX_VALUE);
        this.iFixed(cr);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        return this;
    }

    private JMo_List insert(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_List.class, this, Int.class, null);
        this.iFixed(cr);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos);
        this.list.add(pos - 1, oa[1]);
        return this;
    }

    private JMo_List area(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_List.class, this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int end = ((Int)oa[1]).getValue();
        int size = this.list.size();
        Lib_Error.ifEmpty(cr, this.list.size(), "List");
        Lib_Error.ifNotBetween(cr, 1, Math.min(end, size), start);
        Lib_Error.ifNotBetween(cr, Math.max(1, start), size, end);
        return this.iCutCopy(cr, start, Math.min(this.list.size(), end));
    }

    private JMo_List concat(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.pars(JMo_List.class, this, JMo_List.class)[0];
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        newList.addAll(this.list);
        newList.addAll(list2.getInternalObject());
        return new JMo_List(newList);
    }

    private JMo_List addAll(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.pars(JMo_List.class, this, JMo_List.class)[0];
        this.iFixed(cr);
        this.list.addAll(list2.getInternalObject());
        return this;
    }

    @Override
    protected JMo_List copy(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        ArrayList copy = (ArrayList)this.list.clone();
        return new JMo_List(copy);
    }

    private JMo_List cut(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_List.class, this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int len = ((Int)oa[1]).getValue();
        Lib_Error.ifEmpty(cr, this.list.size(), "List");
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), start);
        if (len == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (len > this.list.size()) {
            len = this.list.size() - start + 1;
        }
        return this.iCutCopy(cr, start, Math.min(this.list.size(), start + len - 1));
    }

    private ObjectCallResult each(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        if (cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'each'", null);
        }
        CallRuntime cpNew = cpOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        for (I_Object it : this.list) {
            result = Lib_Exec.execBlock(cpNew, args, it);
            if (!((result = Lib_Exec.loopResult(result)) instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult eachVertical(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        if (cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'eachAll'", null);
        }
        CallRuntime cpNew = cpOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        int maxItems = 1;
        int pos = 1;
        while (pos <= maxItems) {
            ArrayList<I_Object> cur_al = new ArrayList<I_Object>();
            for (I_Object item : this.list) {
                if ((item = Lib_Convert.getValue(cpNew, item)) instanceof I_AutoBlockList) {
                    ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cpNew.copyNil());
                    int len = abl.size();
                    if (len > maxItems) {
                        maxItems = len;
                    }
                    Nil o = len >= pos ? abl.get(pos - 1) : Nil.NIL;
                    cur_al.add(o);
                    continue;
                }
                cur_al.add(pos == 1 ? item : Nil.NIL);
            }
            JMo_List cur = new JMo_List(cur_al);
            result = Lib_Exec.execBlock(cpNew, args, cur);
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++pos;
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List filter(CallRuntime cr, String method) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Call c = new Call(cr.getSurrBlock(), null, method, cr.call.parCalls, cr.getDebugInfo());
            Bool ok = (Bool)cr.copyCall(c, false).parsEach(JMo_List.class, this, new I_Object[]{test}, Bool.class)[0];
            if (ok.getValue().booleanValue()) {
                result.add(test);
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List map(CallRuntime cr, String method) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Call c = new Call(cr.getSurrBlock(), null, method, cr.call.parCalls, cr.getDebugInfo());
            I_Object[] test2 = new I_Object[]{test};
            I_Object testr = cr.copyCall(c, false).parsEach(JMo_List.class, this, test2, I_Object.class)[0];
            result.add(testr);
            ++p;
        }
        return new JMo_List(result);
    }

    private I_Object reduce(CallRuntime cr, String method) {
        I_Object sum = cr.parsOneAdvance(null, this, 0, I_Object.class);
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] test2 = new I_Object[]{sum, test};
            Call c = new Call(cr.getSurrBlock(), null, method, cr.call.parCalls, cr.getDebugInfo());
            sum = cr.copyCall(c, false).parsEach(JMo_List.class, this, test2, I_Object.class, I_Object.class)[1];
            ++p;
        }
        return sum;
    }

    private JMo_List unfold(CallRuntime cr) {
        cr.pars(JMo_List.class);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Object item : this.list) {
            if (item instanceof I_AutoBlockList) {
                ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cr.copyNil());
                for (I_Object o : abl) {
                    result.add(o);
                }
                continue;
            }
            result.add(item);
        }
        return new JMo_List(result);
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        cr.pars(null);
        return this.list.size() == 0 ? Nil.NIL : this.list.get(0);
    }

    private JMo_List from(CallRuntime cr) {
        I_Object o = cr.pars(JMo_List.class, this, Int.class)[0];
        int par = ((Int)o).getValue();
        int size = this.list.size();
        Lib_Error.ifNotBetween(cr, 1, size, par);
        return this.iCutCopy(cr, par, size);
    }

    @Override
    protected I_Object get(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(null, this, 1, Integer.MAX_VALUE);
        if (oa.length == 1) {
            Int oi = (Int)cr.parType(oa[0], Int.class);
            int pos = Lib_Sequence.realPos(cr, oi.getValue(), this.list.size());
            return this.list.get(pos - 1);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            Int oi = (Int)cr.parType(o, Int.class);
            int pos = Lib_Sequence.realPos(cr, oi.getValue(), this.list.size());
            I_Object g = this.list.get(pos - 1);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private Str implode(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 0, 1);
        if (pars.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (I_Object o : this.list) {
                sb.append(o.toString());
            }
            return new Str(sb.toString());
        }
        I_AtomicValue atomic = (I_AtomicValue)cr.parType(pars[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cr, atomic);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.list.size()) {
            I_Object o = this.list.get(i);
            String s = Lib_Convert.getStringValue(cr, o);
            sb.append(s);
            if (i != this.list.size() - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return new Str(sb.toString());
    }

    @Override
    protected Bool isEmpty(CallRuntime cr) {
        cr.pars(Bool.class);
        return Bool.getObject(this.list.size() == 0);
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        cr.pars(null);
        int len = this.list.size();
        return len == 0 ? Nil.NIL : this.list.get(len - 1);
    }

    private JMo_List left(CallRuntime cr) {
        I_Object o = cr.pars(JMo_List.class, this, Int.class)[0];
        int left = ((Int)o).getValue();
        Lib_Error.ifTooLow(cr, 0, left);
        if (left == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (left > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cr, 1, Math.min(left, this.list.size()));
    }

    private I_Object max(CallRuntime cr) {
        cr.pars(null);
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d > result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object min(CallRuntime cr) {
        cr.pars(null);
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d < result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object average(CallRuntime cr) {
        cr.pars(Dec.class);
        double result = 0.0;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            result += d / (double)this.list.size();
        }
        return new Dec(result);
    }

    private I_Object sum(CallRuntime cr) {
        cr.pars(Dec.class);
        double result = 0.0;
        for (I_Object o : this.list) {
            result += Lib_Convert.getDoubleValue(cr, o);
        }
        return new Dec(result);
    }

    private JMo_List only(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(JMo_List.class, this, 1, Integer.MAX_VALUE);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] i_ObjectArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                String teststr;
                I_Object par = i_ObjectArray[n2];
                if (par instanceof JMo_Regex) {
                    JMo_Regex regex = (JMo_Regex)par;
                    teststr = Lib_Convert.getStringValue(cr, test);
                    if (teststr.matches(regex.toString())) {
                        result.add(test);
                    }
                } else if (par instanceof Str) {
                    String search = Lib_Convert.getStringValue(cr, par);
                    teststr = Lib_Convert.getStringValue(cr, test);
                    if (teststr.equals(search)) {
                        result.add(test);
                    }
                } else if (test.compareTo(par) == 0) {
                    result.add(test);
                }
                ++n2;
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List removeItems(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(JMo_List.class, this, 1, Integer.MAX_VALUE);
        this.iFixed(cr);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).equals(o)) {
                    this.list.remove(i);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private JMo_List removePos(CallRuntime cr) {
        Int o = (Int)cr.pars(JMo_List.class, this, Int.class)[0];
        this.iFixed(cr);
        int oi = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), oi);
        this.list.remove(oi - 1);
        return this;
    }

    private JMo_List clear(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        this.iFixed(cr);
        this.list.clear();
        return this;
    }

    private JMo_List swap(CallRuntime cr) {
        I_Object[] pars = cr.pars(JMo_List.class, this, A_IntNumber.class, A_IntNumber.class);
        this.iFixed(cr);
        int pos1 = Lib_Convert.getIntValue(cr, pars[0]);
        int pos2 = Lib_Convert.getIntValue(cr, pars[1]);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos1);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos2);
        I_Object buffer = this.list.get(--pos1);
        this.list.set(pos1, this.list.get(--pos2));
        this.list.set(pos2, buffer);
        return this;
    }

    private JMo_List reverse(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            dest.add(0, o);
        }
        this.list = dest;
        return this;
    }

    private JMo_List right(CallRuntime cr) {
        I_Object o = cr.pars(JMo_List.class, this, Int.class)[0];
        int right = ((Int)o).getValue();
        Lib_Error.ifTooLow(cr, 0, right);
        if (right == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (right > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cr, Math.max(1, this.list.size() - right + 1), this.list.size());
    }

    @Override
    protected JMo_List set(CallRuntime cr) {
        I_Object[] oa = cr.pars(JMo_List.class, this, Int.class, null);
        int i = Lib_Convert.getIntValue(cr, oa[0]);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), i);
        I_Object o = oa[1];
        if (this.fixedTypes) {
            Class<?> t = o.getClass();
            I_Object curo = this.list.get(i);
            Class<?> curt = curo.getClass();
            if (t != Nil.class && !curt.isAssignableFrom(t)) {
                throw new ExecError(cr, "Wrong Type for List-Position!", "(" + Lib_Type.getName(curt, curo) + ") <-- (" + Lib_Type.getName(t, o) + ") " + o);
            }
        }
        this.list.set(i - 1, o);
        return this;
    }

    private JMo_List shuffle(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        int[] rnd = Lib_Random.getIntArraySet(0, this.list.size() - 1);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        int[] nArray = rnd;
        int n = rnd.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            dest.add(this.list.get(i));
            ++n2;
        }
        this.list = dest;
        return this;
    }

    private JMo_List sort(CallRuntime cr, String method) {
        int parCount = cr.parCount();
        if (parCount == 0) {
            cr.pars(JMo_List.class);
            this.list.sort((o1, o2) -> {
                Object so1 = o1;
                Object so2 = o2;
                if (o1 instanceof I_AtomicValue) {
                    so1 = ((I_AtomicValue)o1).getValue();
                }
                if (o2 instanceof I_AtomicValue) {
                    so2 = ((I_AtomicValue)o2).getValue();
                }
                return Lib_Compare.isEqual(so1, so2) ? 0 : (Lib_Compare.isGreater(so1, so2) ? 1 : -1);
            });
            return this;
        }
        int l = 1;
        while (l < this.list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= this.list.size()) {
                I_Object buffer1 = this.list.get(smallest - 1);
                I_Object buffer2 = this.list.get(m - 1);
                I_Object[] test = new I_Object[]{buffer1, buffer2};
                Call c = new Call(cr.getSurrBlock(), null, method, cr.call.parCalls, cr.getDebugInfo());
                Bool correct = (Bool)cr.copyCall(c, false).parsEach(JMo_List.class, this, test, Bool.class)[0];
                if (!correct.getValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                I_Object buffer1 = this.list.get(pos1);
                I_Object buffer2 = this.list.get(pos2);
                this.list.set(pos1, buffer2);
                this.list.set(pos2, buffer1);
            }
            ++l;
        }
        return this;
    }

    private JMo_List to(CallRuntime cr) {
        I_Object o = cr.pars(JMo_List.class, this, Int.class)[0];
        int par = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), par);
        return this.iCutCopy(cr, 1, par);
    }

    private JMo_List uniq(CallRuntime cr) {
        cr.pars(JMo_List.class);
        int p = 0;
        while (p < this.list.size() - 1) {
            I_Object search = this.list.get(p);
            int q = this.list.size() - 1;
            while (q > p) {
                if (this.list.get(q).equals(search)) {
                    this.list.remove(q);
                }
                --q;
            }
            ++p;
        }
        return this;
    }

    private JMo_List store(CallRuntime cr) {
        I_Object[] pars = cr.getPars(this, null);
        if (pars.length != this.list.size()) {
            throw new CodeError(cr, "Wrong Parameter-Count", "Got " + pars.length + ", need equal to listsize: " + this.list.size());
        }
        int pi = 0;
        while (pi < this.list.size()) {
            I_Object par = cr.parTypeExt(pars[pi], VarLet.class, Nil.class);
            if (!(par instanceof Nil)) {
                Var v = ((VarLet)par).getVar();
                v.let(cr, cr, this.list.get(pi));
            }
            ++pi;
        }
        return this;
    }

    private Str format(CallRuntime cr) {
        String form = ((Str)cr.pars(Str.class, this, Str.class)[0]).getValue();
        int listPos = 0;
        int formPos = 0;
        StringBuilder sb = new StringBuilder();
        while (formPos < form.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(form, formPos);
            formPos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || listPos >= this.list.size()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, this.list.get(listPos++)));
        }
        return new Str(sb.toString());
    }

    private JMo_List iCutCopy(CallRuntime cr, int start, int end) {
        Lib_Error.ifTooLow(cr, start, end);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = start - 1;
        while (i < end) {
            result.add(this.list.get(i));
            ++i;
        }
        return new JMo_List(result);
    }

    private void iFixed(CallRuntime cr) {
        if (this.fixedLength) {
            throw new CodeError(cr, "Can't change size of fixed List", "Adding/Removing elements is not allowed!");
        }
    }
}

