/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.type.Lib_Class;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ClassFinder;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Java;

public class JMo_Java
extends A_Object {
    private String className;
    private final ParCallBuffer classNameCall;
    private final ParCallBuffer constructorParList;
    private Object instance = null;
    private Class<?> instance_class = null;

    public JMo_Java(Object instance) {
        this.instance = instance;
        this.instance_class = instance.getClass();
        this.className = this.instance_class.getSimpleName();
        this.classNameCall = null;
        this.constructorParList = null;
    }

    public JMo_Java(Call[] pars, DebugInfo debugInfo) {
        if (pars.length < 1 || pars.length > 2) {
            throw new ParseError("Invalid parameters for Java-constructor", "Want: (String class-name, List constructor_aruments)", debugInfo);
        }
        this.className = null;
        this.classNameCall = new ParCallBuffer(pars[0]);
        this.constructorParList = pars.length == 1 ? null : new ParCallBuffer(pars[1]);
    }

    public JMo_Java(Class<?> cl, Call[] pars, DebugInfo debugInfo) {
        this.instance_class = cl;
        this.className = cl.getSimpleName();
        this.classNameCall = null;
        if (pars == null || pars.length == 0) {
            this.constructorParList = null;
        } else {
            Call cList = new Call(pars[0].surrounding, new JMo_List(pars), null, null, debugInfo);
            this.constructorParList = new ParCallBuffer(cList);
        }
    }

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkSave(cr, "Java");
        if (this.instance == null) {
            if (this.classNameCall != null) {
                this.classNameCall.init(cr, this, Str.class);
            }
            if (this.constructorParList != null) {
                this.constructorParList.init(cr, this, JMo_List.class);
            }
            if (this.className == null && this.classNameCall != null) {
                I_Object oName = this.classNameCall.get();
                this.className = Lib_Convert.getStringValue(cr, oName);
            }
            if (this.className.startsWith("JMo_")) {
                throw new ExecError(cr, "It's not allowed to create JMo-Objects via Java-Class!", this.className);
            }
            if (this.instance_class == null) {
                this.instance_class = this.searchClass(cr);
            }
            try {
                this.instance = this.getInstance(cr, this.instance_class);
            }
            catch (InstantiationException e) {
                this.instance = null;
            }
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String m) {
        return Lib_Java.exec(cr, this.instance, this.instance_class, m, this);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        String pars = "";
        if (this.constructorParList != null) {
            pars = ", " + this.constructorParList.toString();
        }
        return "Java(\"" + this.className + "\"" + pars + ")";
    }

    private Object getInstance(CallRuntime cr, Class<?> cl) throws InstantiationException {
        if (this.constructorParList == null || ((JMo_List)this.constructorParList.get()).getInternalObject().size() == 0) {
            if (cl.getConstructors().length == 0) {
                return null;
            }
            try {
                return cl.newInstance();
            }
            catch (IllegalAccessException e) {
                String message = e.getMessage().replace("Class " + JMo_Java.class.getName(), "You");
                throw new ExecError(cr, "Illegal access", message);
            }
            catch (SecurityException e) {
                throw new ExecError(cr, "Illegal access", e.getMessage());
            }
        }
        JMo_List parList = (JMo_List)this.constructorParList.get();
        if (!(parList instanceof JMo_List)) {
            throw new ExecError(cr, "Invalid parameters for construtor", "Want constructor-aruments within a list.");
        }
        ArrayList<I_Object> pars = parList.getInternalObject();
        Object[] javaPars = Lib_Java.jmoToJava(pars.toArray(new I_Object[pars.size()]));
        Class<?>[] javaParTypes = this.iJavaTypes(javaPars);
        Constructor<?> ca = null;
        try {
            ca = cl.getConstructor(javaParTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (ca == null) {
            ca = Lib_Class.getConstructor(cl, javaPars);
        }
        if (ca == null) {
            throw new ExecError(cr, "Invalid parameters for constructor", this.className);
        }
        try {
            return ca.newInstance(javaPars);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ExecError(cr, "Can't create object", e.getMessage());
        }
    }

    private Class<?>[] iJavaTypes(Object[] javaPars) {
        Class[] javaParTypes = new Class[javaPars.length];
        int i = 0;
        while (i < javaPars.length) {
            javaParTypes[i] = Lib_Java.toJavaType(javaPars[i]);
            ++i;
        }
        return javaParTypes;
    }

    private Class<?> searchClass(CallRuntime cr) {
        char c1 = this.className.charAt(0);
        Class<?> result = null;
        if (c1 >= 'a' && c1 <= 'z') {
            try {
                result = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new ExecError(cr, "Java-Class not found!", this.className);
            }
        } else {
            result = ClassFinder.getInstance().getJavaClass(this.className);
        }
        if (result == null) {
            throw new ExecError(cr, "Java-Class not found!", this.className);
        }
        if (Lib_Class.descent(result, I_Object.class)) {
            throw new ExecError(cr, "It's not allowed to create JMo-Objects via Java-Class!", this.className);
        }
        return result;
    }

    public Object getJavaObject() {
        return this.instance == null ? this : this.instance;
    }
}

