/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type;

import de.mn77.base.error.Err;
import java.lang.reflect.Constructor;

public class Lib_Class {
    public static String getName(Object o) {
        if (o == null) {
            return "null";
        }
        return Lib_Class.getName(o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getName(Class<?> k) {
        return k.getSimpleName();
    }

    public static <T> T newInstance(Class<T> type, Object ... args) {
        Err.ifNull(type, args);
        Constructor<?> c = Lib_Class.getConstructor(type, args);
        if (c != null) {
            try {
                return (T)c.newInstance(args);
            }
            catch (Exception e) {
                throw Err.exit(e, "Can't create the Instance!");
            }
        }
        throw Err.invalid("No constructor found", type, args, type.getConstructors());
    }

    public static boolean descent(Object obj, Class<?> ofClass) {
        return ofClass.isAssignableFrom(obj.getClass());
    }

    public static boolean descent(Class<?> objclass, Class<?> ofClass) {
        return ofClass.isAssignableFrom(objclass);
    }

    public static Class<?> getClassByName(Iterable<String> imports, String name) {
        Package[] packages;
        for (String pack : imports) {
            try {
                return Class.forName(String.valueOf(pack) + "." + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Package[] packageArray = packages = Package.getPackages();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            Package p = packageArray[n2];
            try {
                return Class.forName(String.valueOf(p.getName()) + "." + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> type, Object[] args) {
        Constructor<?>[] cs;
        Constructor<?>[] constructorArray = cs = type.getConstructors();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Class<?>[] cpars = c.getParameterTypes();
            if (cpars.length == args.length) {
                boolean ok = true;
                int i = 0;
                while (i < cpars.length) {
                    Class<?> cl = cpars[i];
                    Class<?> ocl = args[i].getClass();
                    if (cl != ocl && !Lib_Class.isAtomicValid(cl, ocl) && !cl.isInstance(args[i])) {
                        ok = false;
                        break;
                    }
                    ++i;
                }
                if (ok) {
                    return c;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean isAtomicValid(Class<?> cl, Class<?> ocl) {
        if (!cl.isPrimitive() || ocl.isPrimitive()) {
            return false;
        }
        if (cl == Boolean.TYPE && ocl == Boolean.class) {
            return true;
        }
        if (cl == Byte.TYPE && ocl == Byte.class) {
            return true;
        }
        if (cl == Short.TYPE && ocl == Short.class) {
            return true;
        }
        if (cl == Integer.TYPE && ocl == Integer.class) {
            return true;
        }
        if (cl == Long.TYPE && ocl == Long.class) {
            return true;
        }
        if (cl == Character.TYPE && ocl == Character.class) {
            return true;
        }
        if (cl == Float.TYPE && ocl == Float.class) {
            return true;
        }
        if (cl == Double.TYPE && ocl == Double.class) {
            return true;
        }
        throw Err.invalid(cl, ocl, ocl);
    }
}

