/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.Iterator;

public abstract class A_Table<T>
implements I_Table<T> {
    @Override
    public I_List<T> getRow(int z) {
        if (z < 0) {
            z = this.size() + z + 1;
        }
        MList row = new MList();
        int i = 0;
        while (i < this.getWidth()) {
            row.add(this.get(i + 1, z));
            ++i;
        }
        return row;
    }

    @Override
    public I_List<T> getCol(int col) {
        Err.ifOutOfBounds(this.getWidth(), col);
        Err.ifEqual(col, 0);
        if (col < 0) {
            col = this.getWidth() + col + 1;
        }
        return this.pGetCol(col);
    }

    @Override
    public T get(int col, int row) {
        if (col < 0) {
            col = this.getWidth() + col + 1;
        }
        Err.ifOutOfBounds(1.0, this.getWidth(), col);
        return this.pGet(col, row);
    }

    @Override
    public I_Sequence<T> get(int row) {
        return this.getRow(row);
    }

    @Override
    public Iterator<I_Sequence<T>> iterator() {
        final A_Table table = this;
        return new Iterator<I_Sequence<T>>(){
            private int nextRow = 1;

            @Override
            public boolean hasNext() {
                return this.nextRow <= table.size();
            }

            @Override
            public I_Sequence<T> next() {
                return table.getRow(this.nextRow++);
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }

    @Override
    public int size() {
        return this.pGetCol(1).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void describe() {
        MOut.debugVersetzt(1, this.toStringDebug());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int row = 1;
        while (row <= this.size()) {
            int col = 1;
            while (col <= this.getWidth()) {
                sb.append(this.get(col, row) + (col != this.getWidth() ? "," : ""));
                ++col;
            }
            if (row != this.size()) {
                sb.append("\n");
            }
            ++row;
        }
        return sb.toString();
    }

    @Override
    public void set(int col, int row, T object) {
        Err.ifOutOfBounds(1.0, this.size(), row);
        Err.ifOutOfBounds(1.0, this.getWidth(), col);
        this.pSet(col, row, object);
    }

    @Override
    public void replace(int row, T ... objects) {
        Err.ifOutOfBounds(this.size(), row);
        Err.ifEqual(row, 0);
        int i = 1;
        while (i <= this.getWidth()) {
            this.pSet(i, row, objects[i - 1]);
            ++i;
        }
    }

    @Override
    public void exchange(int row_a, int row_b) {
        Err.ifEqual(row_a, 0);
        Err.ifEqual(row_b, 0);
        Err.ifOutOfBounds(1.0, this.size(), Math.abs(row_a));
        Err.ifOutOfBounds(1.0, this.size(), Math.abs(row_b));
        if (row_a == row_b) {
            MOut.warnung("Exchange of " + row_a + " and " + row_b + " not necessary!");
            return;
        }
        this.pExchange(row_a, row_b);
    }

    @Override
    public I_List<T> remove(int pos) {
        I_List<T> row = this.getRow(pos);
        this.pRemove(pos);
        MList result = new MList();
        for (Object o : row) {
            result.add(o);
        }
        return result;
    }

    @Override
    public I_List<T> removeFirst() {
        return this.remove(1);
    }

    @Override
    public I_List<T> removeLast() {
        return this.remove(this.size());
    }

    @Override
    public void sort(int ... nach) {
        Sort.sort(this, nach);
    }

    @Override
    public void sortRandom() {
        Sort.random(this);
    }

    protected abstract T pGet(int var1, int var2);

    protected abstract I_List<T> pGetCol(int var1);

    protected abstract void pSet(int var1, int var2, T var3);

    protected abstract void pRemove(int var1);

    protected abstract void pExchange(int var1, int var2);
}

