/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.filter;

import de.mn77.base.error.Err;

public class FilterText {
    public static String kuerzeDoppelte(char c, String s) {
        char[] sca;
        Err.ifNull(s);
        StringBuffer sb = new StringBuffer();
        char prior = '\u0000';
        char[] cArray = sca = s.toCharArray();
        int n = sca.length;
        int n2 = 0;
        while (n2 < n) {
            char sc = cArray[n2];
            if (sc != prior || prior != c) {
                sb.append(sc);
            }
            prior = sc;
            ++n2;
        }
        return sb.toString();
    }

    public static String only(char[] chars, String s) {
        Err.ifNull(chars, s);
        StringBuffer sb = new StringBuffer();
        char[] sca = s.toCharArray();
        String chars_str = new String(chars);
        char[] cArray = sca;
        int n = sca.length;
        int n2 = 0;
        while (n2 < n) {
            char sc = cArray[n2];
            if (chars_str.indexOf(sc) >= 0) {
                sb.append(sc);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String only(char[] chars, String s, char replace) {
        Err.ifNull(chars, s);
        StringBuffer sb = new StringBuffer();
        char[] sca = s.toCharArray();
        String chars_str = new String(chars);
        char[] cArray = sca;
        int n = sca.length;
        int n2 = 0;
        while (n2 < n) {
            char sc = cArray[n2];
            sb.append(chars_str.indexOf(sc) >= 0 ? sc : replace);
            ++n2;
        }
        return sb.toString();
    }

    public static String removeChars(char[] chars, String s) {
        Err.ifNull(chars, s);
        StringBuffer sb = new StringBuffer();
        char[] sca = s.toCharArray();
        String chars_str = new String(chars);
        char[] cArray = sca;
        int n = sca.length;
        int n2 = 0;
        while (n2 < n) {
            char sc = cArray[n2];
            if (chars_str.indexOf(sc) < 0) {
                sb.append(sc);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String cut(int start, int length_right, String s) {
        Err.ifNull(s, start);
        if (start < 0) {
            Err.ifToBig(-start, length_right);
        }
        if (start > 0) {
            Err.ifToSmall(-start, length_right);
        }
        Err.ifToSmall(Math.abs(start), s.length());
        if (start < 0) {
            Err.ifToSmall(-start + -length_right - (length_right == 0 ? 0 : 1), s.length());
        }
        if (start > 0) {
            Err.ifToSmall(start + length_right - (length_right == 0 ? 0 : 1), s.length());
        }
        int from1 = start < 0 ? s.length() + start + 1 : start;
        int to1 = from1 + length_right + (length_right < 0 ? 1 : -1);
        if (length_right == 0) {
            return "";
        }
        return s.substring(to1 < from1 ? to1 - 1 : from1 - 1, to1 < from1 ? from1 : to1);
    }

    public static String cut(int start, boolean to_left, String s) {
        int from;
        Err.ifNull(s);
        Err.ifToSmall(Math.abs(start), s.length());
        int n = from = start < 0 ? s.length() + start + 1 : start;
        if (to_left) {
            return s.substring(0, from);
        }
        return s.substring(from - 1);
    }

    public static char chars(int pos, String s) {
        Err.ifEmpty(s);
        Err.ifOutOfBounds(-s.length(), s.length(), pos);
        return pos < 0 ? s.charAt(s.length() + pos) : s.charAt(pos - 1);
    }

    public static String to(char[] chars, boolean last, String s) {
        Err.ifNull(chars, s);
        Err.ifToSmall(1.0, chars.length);
        String chars_str = new String(chars);
        if (last) {
            int p = s.length() - 1;
            while (p >= 0) {
                if (chars_str.indexOf(s.charAt(p)) > -1) {
                    return FilterText.cut(p + 1, true, s);
                }
                --p;
            }
        } else {
            int p = 0;
            while (p <= s.length() - 1) {
                if (chars_str.indexOf(s.charAt(p)) > -1) {
                    return FilterText.cut(p + 1, true, s);
                }
                ++p;
            }
        }
        return s;
    }

    public static String to(String s, boolean last, String to) {
        Err.ifNull(to);
        Err.ifEmpty(s);
        if (last) {
            int p = to.length() - 1;
            while (p >= 0) {
                if (to.indexOf(s, p) > -1) {
                    return FilterText.cut(p + s.length(), true, to);
                }
                --p;
            }
        } else {
            int i = to.indexOf(s);
            if (i >= 0) {
                return FilterText.cut(i + s.length(), true, to);
            }
        }
        return to;
    }

    public static String from(String s, boolean last, String to) {
        Err.ifNull(s, to);
        Err.ifToSmall(1.0, s.length());
        if (last) {
            int start = 0;
            int pos = -1;
            int tmp = -1;
            boolean min1 = false;
            while ((tmp = to.indexOf(s, start)) > -1) {
                min1 = true;
                pos = tmp;
                start = tmp + 1;
            }
            return !min1 ? to : FilterText.cut(pos + 1, false, to);
        }
        int pos = to.indexOf(s);
        return pos < 0 ? to : FilterText.cut(pos + 1, false, to);
    }

    public static String trim(String s, char[] chars, boolean left, boolean right) {
        int posl = 0;
        int posr = s.length() - 1;
        if (left) {
            while (posl < posr && FilterText.isIn(s.charAt(posl), chars)) {
                ++posl;
            }
        }
        if (right) {
            while (posr > posl && FilterText.isIn(s.charAt(posr), chars)) {
                --posr;
            }
        }
        return s.substring(posl, posr + 1);
    }

    private static boolean isIn(char c, char[] search) {
        char[] cArray = search;
        int n = search.length;
        int n2 = 0;
        while (n2 < n) {
            char s = cArray[n2];
            if (s == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String trimToASCII(String s) {
        Err.ifNull(s);
        StringBuilder sb = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '\u0100') {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String trim(String s) {
        Err.ifNull(s);
        return s.trim();
    }

    public static String replace(String search, String replacement, String s) {
        Err.ifNull(search, replacement, s);
        return s.replaceAll("\\Q" + search + "\\E", replacement);
    }

    public static String between(String left, String right, String s) {
        return FilterText.between(left, right, 1, s);
    }

    public static String between(String left, String right, int nr, String s) {
        int nr_pos = 0;
        int start = -1;
        while (nr_pos < nr) {
            if ((start = s.indexOf(left, start + 1)) == -1) break;
            ++nr_pos;
        }
        int end = s.indexOf(right, start += left.length());
        if (end == -1) {
            end = s.length();
        }
        return s.substring(start, end);
    }

    public static String limit(int max_length, String s) {
        return s.length() > max_length ? FilterText.cut(max_length, true, s) : s;
    }

    public static String right(int len, String s) {
        int start = s.length() - len;
        if (start < 0) {
            start = 0;
        }
        return s.substring(start);
    }

    public static String right(String start, String s) {
        if (!s.contains(start)) {
            return "";
        }
        int from = s.lastIndexOf(start);
        if (from == -1) {
            return "";
        }
        return s.substring(from);
    }

    public static String removeTrailingFF(String s) {
        if (s != null && s.length() >= 1 && s.charAt(s.length() - 1) == '\n') {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String matchingLeft(String chars, String s) {
        int end = -1;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (chars.indexOf(c) > -1) {
                ++end;
            } else {
                return s.substring(0, end + 1);
            }
            ++n2;
        }
        return s;
    }
}

