/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.group.Group2;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.PARSER_LEVEL;
import org.jmo_lang.struct.App;
import org.jmo_lang.tools.ClassFinder;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_StringParser;

public class ParseTimeSwitches {
    public void parse(App app, String s, DebugInfo debug) {
        s = s.substring(1).trim();
        char c = s.charAt(0);
        switch (c) {
            case '>': {
                app.strict.checkShortImports(debug);
                this.iJavaImport(s);
                return;
            }
            case '<': {
                app.strict.checkShortImports(debug);
                app.importsAdd(s.substring(1).trim());
                return;
            }
        }
        Group2<String, String[]> g = this.splitLine(s, debug);
        switch ((String)g.o1) {
            case "import": 
            case "include": {
                String[] stringArray = (String[])g.o2;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String si = stringArray[n2];
                    Group2<String, Integer> sg = Lib_Parser.stringGet(si.trim(), debug);
                    String par = (String)sg.o1;
                    if ((Integer)sg.o2 > par.length() + 1) {
                        throw new ParseError("Invalid parameter for include!", s, debug);
                    }
                    app.importsAdd(par);
                    ++n2;
                }
                return;
            }
            case "java": {
                this.iJavaImport(s);
                return;
            }
        }
        app.strict.checkParseTimeSwitch((String)g.o1, debug);
        switch ((String)g.o1) {
            case "debug": {
                MOut.debugDetail();
                MOut.setJavaErrors(true);
                return;
            }
            case "setOutputFile": {
                this.parCheckCount(1, (String[])g.o2, debug);
                String opf = this.parString(((String[])g.o2)[0], debug);
                MOut.debug("OutputFile: " + opf);
                MFile opf2 = opf == null ? null : new MFile(opf);
                app.setOutputFile(opf2);
                return;
            }
            case "strictSave": {
                app.strict.setSave();
                return;
            }
            case "open": {
                return;
            }
            case "strict": {
                app.strict.set(PARSER_LEVEL.STRICT, debug);
                return;
            }
            case "veryStrict": 
            case "verystrict": {
                app.strict.set(PARSER_LEVEL.VERYSTRICT, debug);
                return;
            }
            case "insane": {
                app.strict.set(PARSER_LEVEL.INSANE, debug);
                return;
            }
            case "testAutoBlockAfterFunction": {
                app.strict.setTestAutoBlockAfterFunction();
                return;
            }
        }
        throw new ParseError("Unknown Parsetime-Command", s, debug);
    }

    private void iJavaImport(String s) {
        ClassFinder.getInstance().addImport(s.substring(1).trim());
    }

    private void parCheckCount(int count, String[] pa, DebugInfo debug) {
        if (count != pa.length) {
            throw new ParseError("Wrong count of arguments!", "Want " + count + ", got: " + pa.length, debug);
        }
    }

    private String parString(String s, DebugInfo debug) {
        if ((s = s.trim()).charAt(0) != '\"' || s.charAt(s.length() - 1) != '\"') {
            throw new ParseError("Invalid string!", s, debug);
        }
        return s.substring(1, s.length() - 1);
    }

    private Group2<String, String[]> splitLine(String s, DebugInfo debug) {
        int bi = s.indexOf(40);
        if (bi == -1) {
            return new Group2<String, String[]>(s, new String[0]);
        }
        String command = s.substring(0, bi).trim();
        String rem = s.substring(bi).trim();
        if (rem.charAt(rem.length() - 1) != ')') {
            throw new ParseError("Closing bracket is missing!", s, debug);
        }
        rem = rem.substring(1, rem.length() - 1);
        ArrayList<String> pa = new ArrayList<String>();
        while (rem.length() > 0) {
            Group2<String, String> result = Lib_StringParser.getNextPar(rem, debug);
            pa.add((String)result.o1);
            if (((String)result.o2).equals(rem)) {
                throw new ParseError("Invalid ParseTime-Command!", s, debug);
            }
            rem = (String)result.o2;
        }
        String[] sa = pa.toArray(new String[pa.size()]);
        return new Group2<String, String[]>(command, sa);
    }
}

