/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvText;
import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.spec.numbersys.Hex;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.A_Chars;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.mc.MagicPosition;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.sys.JMo_Cmd;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Sequence;
import org.jmo_lang.tools.Lib_StrFormat;
import org.jmo_lang.tools.Lib_Type;

public class Str
extends A_Chars
implements I_Atomic,
I_AutoBlockDo,
I_AutoBlockList {
    private final String value;

    public Str(String val) {
        Err.ifNull(val);
        this.value = val;
    }

    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.sub(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.begin(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.cut(cr));
            }
            case "area": 
            case "cutTo": {
                return A_Object.stdResult(this.cutTo(cr));
            }
            case "left": {
                return A_Object.stdResult(this.left(cr));
            }
            case "right": {
                return A_Object.stdResult(this.right(cr));
            }
            case "to": {
                return A_Object.stdResult(this.toPos(cr));
            }
            case "from": {
                return A_Object.stdResult(this.fromPos(cr));
            }
            case "fromFirst": {
                return A_Object.stdResult(this.fromFirst(cr, true));
            }
            case "afterFirst": {
                return A_Object.stdResult(this.fromFirst(cr, false));
            }
            case "toFirst": {
                return A_Object.stdResult(this.toFirst(cr, true));
            }
            case "beforeFirst": {
                return A_Object.stdResult(this.toFirst(cr, false));
            }
            case "fromLast": {
                return A_Object.stdResult(this.fromLast(cr, true));
            }
            case "afterLast": {
                return A_Object.stdResult(this.fromLast(cr, false));
            }
            case "toLast": {
                return A_Object.stdResult(this.toLast(cr, true));
            }
            case "beforeLast": {
                return A_Object.stdResult(this.toLast(cr, false));
            }
            case "explode": 
            case "/": 
            case "split": {
                return A_Object.stdResult(this.split(cr));
            }
            case "splitKeep": {
                return A_Object.stdResult(this.splitKeep(cr));
            }
            case "lines": {
                return A_Object.stdResult(this.lines(cr));
            }
            case "column": {
                return A_Object.stdResult(this.column(cr));
            }
            case "capitalize": 
            case "capital": {
                return A_Object.stdResult(this.capital(cr));
            }
            case "trim": {
                return A_Object.stdResult(this.trim(cr, true, true));
            }
            case "trimLeft": {
                return A_Object.stdResult(this.trim(cr, true, false));
            }
            case "trimRight": {
                return A_Object.stdResult(this.trim(cr, false, true));
            }
            case "startsWith": {
                return A_Object.stdResult(this.startsWith(cr));
            }
            case "has": {
                return A_Object.stdResult(this.has(cr));
            }
            case "endsWith": {
                return A_Object.stdResult(this.endsWith(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.search(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.search(cr, false));
            }
            case "replace": {
                return A_Object.stdResult(this.replace(cr));
            }
            case "match": {
                return A_Object.stdResult(this.match(cr));
            }
            case "align": {
                return A_Object.stdResult(this.align(cr));
            }
            case "fill": {
                return A_Object.stdResult(this.fill(cr));
            }
            case "jmo": {
                return A_Object.stdResult(this.exec_jmo(cr));
            }
            case "cmd": {
                return A_Object.stdResult(this.exec_cmd(cr));
            }
            case "fromHex": 
            case "hexToInt": {
                return A_Object.stdResult(this.hexToInt(cr));
            }
            case "chars": {
                return A_Object.stdResult(this.chars(cr));
            }
            case "each": {
                return this.each(cr);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.add(new Char(c));
            ++n2;
        }
        return result;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Str) {
            return this.value.compareTo(((Str)o).getValue());
        }
        return null;
    }

    private ObjectCallResult each(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        Lib_Exec.checkLoopWithout(cpOld, pars);
        CallRuntime cpNew = cpOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = Nil.NIL;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Char it = new Char(c);
            result = Lib_Exec.execBlock(cpNew, args, it);
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++n2;
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List chars(CallRuntime cr) {
        cr.pars(JMo_List.class);
        char[] ca = this.value.toCharArray();
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            al.add(new Char(c));
            ++n2;
        }
        return new JMo_List(al);
    }

    private Str fill(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(Str.class, this, 0, Integer.MAX_VALUE);
        int oaPos = 0;
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < this.value.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(this.value, pos);
            pos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || oaPos >= oa.length) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, oa[oaPos++]));
        }
        return new Str(sb.toString());
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.STR, to, this, this.getValue());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "\"" + this.value + "\"";
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.parsExt(Bool.class, this, new Class[][]{{Str.class, Char.class, Int.class}})[0];
        String par = Lib_Convert.getStringValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value.compareTo(par) > 0);
            }
            case L: {
                return Bool.getObject(this.value.compareTo(par) < 0);
            }
            case GE: {
                return Bool.getObject(this.value.compareTo(par) >= 0);
            }
            case LE: {
                return Bool.getObject(this.value.compareTo(par) <= 0);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected Str add(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 1);
        String result = this.value;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            result = String.valueOf(result) + Lib_Convert.getStringValue(cr, par);
            ++n2;
        }
        return new Str(result);
    }

    private Str begin(CallRuntime cr) {
        I_Object par = cr.pars(Str.class, this, I_Object.class)[0];
        String ps = Lib_Convert.getStringValue(cr, par);
        return new Str(String.valueOf(ps) + this.value);
    }

    private Str align(CallRuntime cr) {
        I_Object[] pars = cr.pars(Str.class, this, MagicPosition.class, A_IntNumber.class);
        int par = Lib_Convert.getIntValue(cr, pars[1]);
        MagicPosition pos1 = (MagicPosition)Lib_Convert.getValue(cr, pars[0]);
        POSITION pos2 = pos1.get();
        if (!Lib_Position.isHorizontal(pos2)) {
            throw new ExecError(cr, "Invalid position", "Only left,center and right are alowed. Got: " + pos1);
        }
        String s = FormText.width(par, ' ', this.value, (POSITION_H)((Object)pos2), false);
        return new Str(s);
    }

    private Str capital(CallRuntime cr) {
        cr.pars(Str.class);
        String s = this.value.toLowerCase();
        String result = "";
        if (s.length() > 0) {
            result = ("" + s.charAt(0)).toUpperCase();
        }
        if (s.length() > 1) {
            result = String.valueOf(result) + s.substring(1);
        }
        return new Str(result);
    }

    @Override
    protected Str caseDown(CallRuntime cr) {
        cr.pars(Str.class);
        return new Str(this.value.toLowerCase());
    }

    @Override
    protected Str caseUp(CallRuntime cr) {
        cr.pars(Str.class);
        return new Str(this.value.toUpperCase());
    }

    @Override
    protected Char charAt(CallRuntime cr) {
        int pos = Lib_Convert.getIntValue(cr, cr.pars(Char.class, this, A_IntNumber.class)[0]);
        pos = Lib_Sequence.realPos(cr, pos, this.value.length());
        return new Char(this.value.charAt(pos - 1));
    }

    private Str column(CallRuntime cr) {
        I_Object[] oa = cr.pars(Str.class, this, I_AtomicValue.class, A_IntNumber.class);
        String delimiter = Lib_Convert.getStringValue(cr, oa[0]);
        String[] sa = this.value.split(delimiter);
        int col = Lib_Convert.getIntValue(cr, oa[1]);
        Lib_Error.ifNotBetween(cr, 1, sa.length, col);
        return new Str(sa[col - 1]);
    }

    private Str cut(CallRuntime cr) {
        I_Object[] pars = cr.pars(Str.class, this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, pars[0]);
        int len = Lib_Convert.getIntValue(cr, pars[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from);
        Lib_Error.ifNotBetween(cr, 0, this.value.length() - from + 1, len);
        int to = from + len;
        String s = this.value.substring(from - 1, to - 1);
        return new Str(s);
    }

    private Str cutTo(CallRuntime cr) {
        I_Object[] pars = cr.pars(Str.class, this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, pars[0]);
        int to = Lib_Convert.getIntValue(cr, pars[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from);
        Lib_Error.ifNotBetween(cr, from, this.value.length(), to);
        String s = this.value.substring(from - 1, to);
        return new Str(s);
    }

    private Bool endsWith(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsFlex(Bool.class, this, 1);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.parType(o, I_AtomicValue.class));
            if (this.value.endsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private I_Object exec_cmd(CallRuntime cr) {
        cr.pars(JMo_Cmd.class);
        cr.getStrict().checkSave(cr, "Str.command");
        Call c = new Call(cr.getSurrBlock(), this, cr.getDebugInfo());
        return new JMo_Cmd(c);
    }

    private Str exec_jmo(CallRuntime cr) {
        cr.pars(Str.class);
        cr.getStrict().checkSave(cr, "String.jmo");
        try {
            Parser_App parser = new Parser_App();
            App app = parser.parseText(this.value);
            app.setOutputFile(cr.getApp().getOutputFile());
            String result = app.exec(null);
            return new Str(result);
        }
        catch (Err_FileSys e) {
            Err.show(e);
            throw new ExecError(cr, "Execution-Error", e.getMessage());
        }
    }

    private Str fromPos(CallRuntime cr) {
        I_Object par = cr.pars(Str.class, this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, par);
        if (begin == 0) {
            throw new ExecError(cr, "Wrong position in string", "Position can't be 0");
        }
        if (begin < 0) {
            begin = this.value.length() + begin + 1;
        }
        if (begin < 1 || begin > this.value.length()) {
            return new Str("");
        }
        String s = this.value.substring(begin - 1);
        return new Str(s);
    }

    private Str fromFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 1);
        int idx = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 > -1 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = idx >= 0 ? this.value.substring(idx + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Str fromLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 1);
        int beginindex = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 > -1 && (beginindex == -1 || idx2 > beginindex)) {
                beginindex = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = beginindex >= 0 ? this.value.substring(beginindex + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Bool has(CallRuntime cr) {
        I_AtomicValue par = (I_AtomicValue)cr.pars(Bool.class, this, I_AtomicValue.class)[0];
        int index = this.value.indexOf(Lib_Convert.getStringValue(cr, par));
        return Bool.getObject(index > -1);
    }

    private Int hexToInt(CallRuntime cr) {
        cr.pars(Int.class);
        int i = Hex.fromHex(this.value);
        return new Int(i);
    }

    private Str left(CallRuntime cr) {
        I_Object par = cr.pars(Str.class, this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, par);
        if (to > this.value.length()) {
            return this;
        }
        Lib_Error.ifTooLow(cr, 1, to);
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private JMo_List lines(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        String[] sa = this.value.split("\n");
        JMo_List list = new JMo_List();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.internalAdd(new Str(s));
            ++n2;
        }
        return list;
    }

    private Bool match(CallRuntime cr) {
        JMo_Regex par = (JMo_Regex)cr.pars(Bool.class, this, JMo_Regex.class)[0];
        return Bool.getObject(this.value.matches(par.getValue()));
    }

    @Override
    protected Str multi(CallRuntime cr) {
        I_Object par = cr.pars(Str.class, this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, par);
        String s = FormText.sequence(this.value, (long)i);
        return new Str(s);
    }

    private Str replace(CallRuntime cr) {
        I_Object[] pars = cr.parsExt(Str.class, this, {I_AtomicValue.class, JMo_Regex.class}, {I_AtomicValue.class});
        String s2 = Lib_Convert.getStringValue(cr, pars[1]);
        if (pars[0] instanceof JMo_Regex) {
            String regex = ((JMo_Regex)pars[0]).getValue();
            try {
                String result = this.value.replaceAll(regex, s2);
                return new Str(result);
            }
            catch (PatternSyntaxException e) {
                throw new ExecError(cr, "Invalid Pattern Syntax", e.getMessage());
            }
        }
        String s1 = Lib_Convert.getStringValue(cr, pars[0]);
        String result = this.value.replace(s1, s2);
        return new Str(result);
    }

    private Str right(CallRuntime cr) {
        int len;
        I_Object par = cr.pars(Str.class, this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, par);
        if (begin > (len = this.value.length())) {
            return this;
        }
        Lib_Error.ifTooLow(cr, 1, begin);
        String s = this.value.substring(len - begin);
        return new Str(s);
    }

    private I_Atomic search(CallRuntime cr, boolean first) {
        I_Object par = cr.pars(Int.class, this, I_Object.class)[0];
        String search = Lib_Convert.getStringValue(cr, par);
        int idx = first ? this.value.indexOf(search) : this.value.lastIndexOf(search);
        return idx < 0 ? Nil.NIL : new Int(idx + 1);
    }

    @Override
    protected Str changeChar(CallRuntime cr) {
        I_Object[] oa = cr.pars(Str.class, this, A_IntNumber.class, A_Chars.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        pos = Lib_Sequence.realPos(cr, pos, this.value.length());
        I_Object o = oa[1];
        String n = Lib_Convert.getStringValue(cr, o);
        String l = pos == 1 ? "" : this.value.substring(0, pos - 1);
        String r = pos == this.value.length() ? "" : this.value.substring(pos);
        return new Str(String.valueOf(l) + n + r);
    }

    private JMo_List split(CallRuntime cr) {
        I_Object par = cr.parsExt(JMo_List.class, this, new Class[][]{{A_Chars.class, A_IntNumber.class, JMo_Regex.class}})[0];
        if (par instanceof JMo_Regex) {
            String regex = par.toString();
            String[] sa = this.value.split(regex);
            JMo_List list = new JMo_List();
            String[] stringArray = sa;
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.internalAdd(new Str(s));
                ++n2;
            }
            return list;
        }
        if (par instanceof Int) {
            int count = Lib_Convert.getIntValue(cr, par);
            Lib_Error.ifTooLow(cr, 1, count);
            JMo_List list = new JMo_List();
            String str = this.value;
            int start = 0;
            while (start < str.length()) {
                list.internalAdd(new Str(str.substring(start, Math.min(str.length(), start + count))));
                start += count;
            }
            return list;
        }
        String delimiter = "" + ((I_AtomicValue)par).getValue();
        I_List<String> sl = ConvText.toList(delimiter, this.value);
        JMo_List list = new JMo_List();
        for (String s : sl) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private JMo_List splitKeep(CallRuntime cr) {
        I_Object o = cr.parsExt(JMo_List.class, this, new Class[][]{{I_AtomicValue.class, JMo_List.class}})[0];
        TypeTable2<String, Boolean> tab = null;
        if (o instanceof I_AtomicValue) {
            tab = ConvText.splitToTable(this.value, o.toString());
        } else if (o instanceof JMo_List) {
            JMo_List delimiters = (JMo_List)o;
            ArrayList<String> al = new ArrayList<String>();
            for (I_Object delimiter : delimiters.getInternalObject()) {
                if (!(delimiter instanceof I_AtomicValue)) {
                    throw new ExecError(cr, "Non-Atomic Delimiter", "Got: " + Lib_Type.getName(delimiter.getClass(), delimiter));
                }
                al.add(Lib_Convert.getStringValue(cr, delimiter));
            }
            tab = ConvText.splitToTable(this.value, al.toArray(new String[al.size()]));
        } else {
            throw Err.todo(o);
        }
        I_List<String> data = tab.getCol1();
        JMo_List list = new JMo_List();
        for (String s : data) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private Bool startsWith(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsFlex(Bool.class, this, 1);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.parType(o, I_AtomicValue.class));
            if (this.value.startsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private Str sub(CallRuntime cr) {
        I_Object o = cr.pars(Str.class, this, I_Object.class)[0];
        return new Str(this.value.replace(Lib_Convert.getStringValue(cr, o), ""));
    }

    private Str toPos(CallRuntime cr) {
        I_Object par = cr.pars(Str.class, this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, par);
        if (to == 0) {
            throw new ExecError(cr, "Wrong position in string", "Position can't be 0");
        }
        if (to >= this.value.length()) {
            return new Str(this.value);
        }
        if (to < 0 && Math.abs(to) > this.value.length()) {
            return new Str("");
        }
        if (to < 0) {
            to = this.value.length() + to + 1;
        }
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Str toFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 1);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str toLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 1);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 > idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str trim(CallRuntime cr, boolean left, boolean right) {
        I_Object[] pars = cr.parsFlex(Str.class, this, 0);
        if (pars.length == 0) {
            String s = FilterText.trim(this.value, new char[]{' ', '\t', '\r', '\f', '\n'}, left, right);
            return new Str(s);
        }
        char[] ca = new char[pars.length];
        int i = 0;
        while (i < pars.length) {
            ca[i] = ((Char)cr.parType(pars[i], Char.class)).getValue().charValue();
            ++i;
        }
        String s = FilterText.trim(this.value, ca, left, right);
        return new Str(s);
    }
}

