/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Byte
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final byte value;

    public JMo_Byte(byte val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof JMo_Byte) {
            return new Byte(this.value).compareTo(((JMo_Byte)o).getValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.BYTE, to, this, this.getValue());
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.parsExt(Bool.class, this, new Class[][]{{Bool.class, Char.class, JMo_Byte.class, Dec.class}})[0];
        int par = Lib_Convert.getIntValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value > par);
            }
            case L: {
                return Bool.getObject(this.value < par);
            }
            case GE: {
                return Bool.getObject(this.value >= par);
            }
            case LE: {
                return Bool.getObject(this.value <= par);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new Int(~this.value);
            }
            case ABS: {
                return new Int(Math.abs(this.value));
            }
        }
        throw new CodeError(cr, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case INC: {
                    return new JMo_Byte((byte)(this.value + 1));
                }
                case DEC: {
                    return new JMo_Byte((byte)(this.value - 1));
                }
                case POW: {
                    return new Int(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
            }
            throw Err.invalid(new Object[]{cr, op, pars});
        }
        A_Number par = (A_Number)cr.parType(pars[0], A_Number.class);
        double pard = Lib_Convert.getDoubleValue(cr, par);
        int pari = Lib_Convert.getIntValue(cr, par);
        switch (op) {
            case INC: {
                return new JMo_Byte((byte)(this.value + pari));
            }
            case DEC: {
                return new JMo_Byte((byte)(this.value - pari));
            }
            case POW: {
                if (par instanceof JMo_Long) {
                    long parl = Lib_Convert.getLongValue(cr, par);
                    return new JMo_Long(Math.round(Math.pow(this.value, parl)));
                }
                if (par instanceof A_IntNumber) {
                    return new Int((int)Math.round(Math.pow(this.value, pari)));
                }
                return new Dec(Math.pow(this.value, pard));
            }
            case SQR: {
                return new Dec(Math.exp(Math.log(this.value) / pard));
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pard);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number paro) {
        byte val = this.value;
        if (paro instanceof JMo_Long) {
            long par = Lib_Convert.getLongValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new JMo_Long((long)this.value + par);
                }
                case SUB: {
                    return new JMo_Long((long)this.value - par);
                }
                case MUL: {
                    return new JMo_Long((long)this.value * par);
                }
                case DIV: {
                    if (par == 0L) {
                        throw new ExecError(cr, "Division by zero", this.value + "/" + par);
                    }
                    return new Dec((double)this.value / (double)par);
                }
                case MOD: {
                    return new JMo_Long((long)this.value % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
            }
        } else if (paro instanceof A_IntNumber) {
            int par = Lib_Convert.getIntValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Int(this.value + par);
                }
                case SUB: {
                    return new Int(this.value - par);
                }
                case MUL: {
                    return new Int(this.value * par);
                }
                case DIV: {
                    if (par == 0) {
                        throw new ExecError(cr, "Division by zero", this.value + "/" + par);
                    }
                    return new Dec((double)this.value / (double)par);
                }
                case MOD: {
                    return new Int(this.value % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
            }
        } else {
            double par = Lib_Convert.getDoubleValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Dec((double)val + par);
                }
                case SUB: {
                    return new Dec((double)val - par);
                }
                case MUL: {
                    return new Dec((double)val * par);
                }
                case DIV: {
                    if (par == 0.0) {
                        throw new ExecError(cr, "Division by zero", val + "/" + par);
                    }
                    return new Dec((double)val / par);
                }
                case MOD: {
                    return new Dec((double)val % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + Lib_Type.getName(paro));
    }
}

