/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.keypot.KeyPotList;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;

public abstract class A_EventObject
extends A_Object {
    private KeyPotList<String, Call> events;

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        char c0 = method.charAt(0);
        if (c0 == ':') {
            String m = cr.call.method.substring(1);
            A_EventObject obj = this;
            if (!m.equals("@varChanged")) {
                I_Object o = Lib_Convert.getValue(cr, this);
                if (o instanceof A_EventObject) {
                    obj = (A_EventObject)o;
                } else {
                    throw new CodeError(cr, "Wrong event-definition", "This object has no events: " + o);
                }
            }
            obj.eventAddHandler(cr, m, cr.call);
            return new ObjectCallResult(this, true);
        }
        if (c0 == '@') {
            if (cr.parCount() != 0) {
                throw new CodeError(cr, "Wrong event-definition", "No Parameter allowed for events");
            }
            if (cr.getStream() != null) {
                throw new CodeError(cr, "Invalid call of a event", "Call of event " + method + " with stream");
            }
            if (cr.getCallBlock() != null) {
                throw new CodeError(cr, "Invalid call of a event", "Call of event " + method + " with block");
            }
            return this.callEvent(cr, method);
        }
        return this.callMethod(cr, method);
    }

    public void eventAddHandler(CallRuntime cr, String event, Call c) {
        if (this.events == null) {
            this.events = new KeyPotList();
        }
        if (!this.validateEvent(cr, event)) {
            throw new CodeError(cr, "Unknown event", "Got definition for: " + event);
        }
        this.events.add(event, c);
    }

    public void eventRun(CallRuntime cr, String event, I_Object blockIT) {
        try {
            if (this.events != null) {
                I_Sequence handlersStatic = this.events.getPot((Object)event);
                for (Call b : handlersStatic) {
                    try {
                        b.getBlock().exec(cr, blockIT);
                    }
                    catch (ReturnException r) {
                        Lib_Exec.checkIsReturn(cr, r);
                    }
                }
            }
        }
        catch (Throwable t) {
            Err.show(t);
        }
    }

    @Override
    public abstract void init(CallRuntime var1);

    protected abstract ObjectCallResult callMethod(CallRuntime var1, String var2);

    protected abstract ObjectCallResult callEvent(CallRuntime var1, String var2);

    protected abstract boolean validateEvent(CallRuntime var1, String var2);
}

