/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.sort;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.struct.sort.I_Sortable;
import de.mn77.base.data.struct.sort.algo.GnomeSort;
import de.mn77.base.data.struct.sort.algo.MergeSort;
import de.mn77.base.error.Err;

public class Sort {
    private static final GnomeSort gnome = new GnomeSort();
    private static final MergeSort merge = new MergeSort();

    public static void sort(I_Sortable<?> tab, int ... columnOrder) {
        Err.ifNull(tab);
        if (columnOrder == null || columnOrder.length == 0) {
            columnOrder = new int[]{1};
        }
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Err.ifOutOfBounds(1.0, tab.getWidth(), Math.abs(i));
            ++n2;
        }
        if (tab.size() <= 10) {
            gnome.sort(tab, columnOrder);
        } else {
            merge.sort(tab, columnOrder);
        }
    }

    public static void random(I_Sortable<?> tab) {
        Err.ifNull(tab);
        if (tab.size() <= 1) {
            return;
        }
        int[] rnd = Lib_Random.getIntArraySet(1, tab.size());
        tab.sortLike(rnd);
    }
}

