/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.constant.DATE;
import de.mn77.base.data.constant.LANGUAGE;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.data.type.datetime.format.FORM_DATETIME;
import de.mn77.base.data.type.datetime.format.FORM_TIME;
import de.mn77.base.error.Err;

public class FormDateTime {
    public static String toText(I_Time time, Object ... format) {
        Err.ifNull(time);
        String result = "";
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                result = String.valueOf(result) + o;
            } else if (o == FORM_TIME.STD_2) {
                result = String.valueOf(result) + FormNumber.width(2, time.getHours(), false);
            } else if (o == FORM_TIME.STD) {
                result = String.valueOf(result) + time.getHours();
            } else if (o == FORM_TIME.MIN_2) {
                result = String.valueOf(result) + FormNumber.width(2, time.getMinutes(), false);
            } else if (o == FORM_TIME.MIN) {
                result = String.valueOf(result) + time.getMinutes();
            } else if (o == FORM_TIME.SEK_2) {
                result = String.valueOf(result) + FormNumber.width(2, time.getSeconds(), false);
            } else if (o == FORM_TIME.SEK) {
                result = String.valueOf(result) + time.getSeconds();
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return result;
    }

    public static String toText(I_Date date, LANGUAGE lang, Object ... format) {
        Err.ifNull(format);
        Err.ifToSmall(1.0, format.length);
        String result = "";
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                result = String.valueOf(result) + o;
            } else if (o == FORM_DATE.YEAR_4) {
                result = String.valueOf(result) + FormNumber.width(4, date.getYear(), false);
            } else if (o == FORM_DATE.YEAR_2) {
                String tmp = "" + date.getYear();
                result = tmp.length() >= 2 ? String.valueOf(result) + tmp.substring(tmp.length() - 2, tmp.length()) : String.valueOf(result) + FormText.width(2, '0', tmp, POSITION_H.RIGHT, false);
            } else if (o == FORM_DATE.YEAR) {
                result = String.valueOf(result) + date.getYear();
            } else if (o == FORM_DATE.MONTH) {
                result = String.valueOf(result) + date.getMonth();
            } else if (o == FORM_DATE.MONTH_2) {
                result = String.valueOf(result) + FormNumber.width(2, date.getMonth(), false);
            } else if (o == FORM_DATE.MONTH_TEXT) {
                result = String.valueOf(result) + DATE.NAME_MONTH_DE[date.getMonth() - 1];
            } else if (o == FORM_DATE.MONTH_TEXT_3) {
                result = String.valueOf(result) + DATE.NAME_MONTH_DE[date.getMonth() - 1].substring(0, 3);
            } else if (o == FORM_DATE.DAY) {
                result = String.valueOf(result) + date.getDay();
            } else if (o == FORM_DATE.DAY_2) {
                result = String.valueOf(result) + FormNumber.width(2, date.getDay(), false);
            } else if (o == FORM_DATE._DAYS_OF_MONTH) {
                result = String.valueOf(result) + FormNumber.width(2, Lib_DateTime.daysOfMonth(date.getMonth(), date.getYear()), false);
            } else if (o == FORM_DATE.DAY_WEEK_TEXT_3) {
                result = String.valueOf(result) + Lib_DateTime.nameDayOfWeek(date.getDayOfWeek(), lang).substring(0, 3);
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return result;
    }

    public static String toTextIT(I_Date date) {
        return FormDateTime.toText(date, LANGUAGE.EN, FORM_DATE.GROUP_IT);
    }

    public static String toText(I_Date date) {
        return FormDateTime.toText(date, LANGUAGE.EN, FORM_DATE.GROUP_DEFAULT);
    }

    public static String toText(I_DateTime time, Object ... format) {
        Err.ifNull(time);
        if (format == null || format.length == 0) {
            return FormDateTime.toText(time);
        }
        String result = "";
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                result = String.valueOf(result) + o;
            } else if (o instanceof FORM_DATE) {
                result = String.valueOf(result) + FormDateTime.toText(time.getDate(), LANGUAGE.EN, o);
            } else if (o instanceof FORM_TIME) {
                result = String.valueOf(result) + FormDateTime.toText(time.getTime(), o);
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return result;
    }

    public static String toTextIT(I_DateTime datetime) {
        return FormDateTime.toText(datetime, FORM_DATETIME.GROUP_IT);
    }

    public static String zuTextDS(I_DateTime datetime) {
        return FormDateTime.toText(datetime, FORM_DATETIME.GROUP_FILESYS);
    }

    public static String toText(I_DateTime datetime) {
        return FormDateTime.toText(datetime, FORM_DATETIME.GROUP_DEFAULT);
    }
}

