/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.struct.Call;

public class Lib_Prio {
    public static boolean streamPrio(Call c, Call next) {
        if (next == null || c.method == null) {
            return false;
        }
        return next.prio > c.prio;
    }

    public static byte streamPrio(String s, DebugInfo debug) {
        char c = s.charAt(0);
        if ("abcdefghijklmnopqrstuvwxyz?@:".indexOf(c) >= 0) {
            return 99;
        }
        switch (s.length()) {
            case 1: {
                switch (c) {
                    case '+': 
                    case '-': {
                        return 22;
                    }
                    case '&': {
                        return 13;
                    }
                    case '|': {
                        return 11;
                    }
                    case '^': {
                        return 12;
                    }
                    case '%': 
                    case '*': 
                    case '/': {
                        return 23;
                    }
                    case '!': 
                    case '~': {
                        return 50;
                    }
                    case '=': {
                        return 0;
                    }
                    case '<': 
                    case '>': {
                        return 5;
                    }
                    case '\u2248': {
                        return 20;
                    }
                    case '\u00b6': {
                        return 0;
                    }
                }
            }
            case 2: {
                switch (s) {
                    case "!=": 
                    case "<>": 
                    case "==": {
                        return 4;
                    }
                    case "<=": 
                    case ">=": {
                        return 5;
                    }
                    case "&&": {
                        return 3;
                    }
                    case "||": {
                        return 1;
                    }
                    case "^^": {
                        return 2;
                    }
                    case "**": 
                    case "++": 
                    case "--": 
                    case "//": {
                        return 40;
                    }
                    case "<<": 
                    case ">>": {
                        return 21;
                    }
                    case "+=": 
                    case "-=": {
                        return 33;
                    }
                    case "%=": 
                    case "*=": 
                    case "/=": {
                        return 34;
                    }
                    case "&=": {
                        return 32;
                    }
                    case "|=": {
                        return 30;
                    }
                    case "^=": {
                        return 31;
                    }
                }
            }
            case 3: {
                switch (s) {
                    case "!&&": {
                        return 3;
                    }
                    case "!||": {
                        return 1;
                    }
                    case "!^^": {
                        return 2;
                    }
                }
            }
        }
        throw new ParseError("Unknown function", "Can't get priority for: " + s, debug);
    }
}

