/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Type;

public class Lib_Par {
    public static void checkBlock(CallRuntime cr, Class<?> result) {
        if (result != null && Lib_Class.descent(result, I_AutoBlockDo.class)) {
            return;
        }
        Lib_Par.checkBlockForbidden(cr);
    }

    public static void checkBlockNecessary(CallRuntime cr) {
        if (cr.call.getBlock() == null) {
            throw new CodeError(cr, "Invalid function-call", "Block needed for this function");
        }
    }

    public static void checkBlockForbidden(CallRuntime cr) {
        if (cr.call.getBlock() != null) {
            throw new CodeError(cr, "Invalid function-call", "No Block allowed for this function");
        }
    }

    public static I_Object checkParAdvance(CallRuntime cr, I_Object streamIt, int parNr, Class<?> type) {
        I_Object par = cr.getParAdvance(streamIt, parNr);
        return Lib_Par.checkPar(cr, par, type);
    }

    public static I_Object checkPar(CallRuntime cr, I_Object par, Class<?> type) {
        I_Object parReal = Lib_Convert.getValue(cr, par);
        if (type != null && !type.isAssignableFrom(parReal.getClass())) {
            throw new CodeError(cr, "Invalid type of parameter", "Got " + Lib_Type.getName(parReal.getClass(), par) + "(" + par.toDebug(cr) + "), expected: " + Lib_Par.typelistToText(type));
        }
        return parReal;
    }

    public static I_Object checkParExt(CallRuntime cr, I_Object par, Class<?>[] types) {
        I_Object parReal = Lib_Convert.getValue(cr, par);
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(parReal.getClass())) {
                return parReal;
            }
            ++n2;
        }
        throw new CodeError(cr, "Invalid type of parameter", "Got " + par.getTypeName() + "(" + par.toDebug(cr) + "), expected: " + Lib_Par.typelistToText(new Class[][]{types}));
    }

    public static I_Object[] checkPars(CallRuntime cr, I_Object streamIt, I_Object[] eachIt, Class<?> ... types) {
        Err.ifNull(cr.call);
        if (streamIt == null && types.length == 0 && cr.parCount() > 0) {
            throw new CodeError(cr, "Invalid number of parameters", "No parameters allowed");
        }
        I_Object[] pars = cr.getPars(streamIt, eachIt);
        int oal = pars.length;
        Lib_Error.ifPars(oal, types.length, types.length, cr.getDebugInfo());
        int i = 0;
        while (i < oal) {
            pars[i] = Lib_Par.checkPar(cr, pars[i], types[i]);
            ++i;
        }
        return pars;
    }

    public static I_Object[] checkParsExt(CallRuntime cr, I_Object streamIt, Class<?>[] ... types) {
        I_Object[] pars = cr.getPars(streamIt, null);
        Lib_Error.ifPars(pars.length, types.length, types.length, cr.getDebugInfo());
        int i = 0;
        while (i < pars.length) {
            pars[i] = Lib_Convert.getValue(cr, pars[i]);
            if (types[i] != null) {
                boolean hit = false;
                Class<?>[] classArray = types[i];
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> t = classArray[n2];
                    if (t.isAssignableFrom(pars[i].getClass())) {
                        hit = true;
                        break;
                    }
                    ++n2;
                }
                if (!hit) {
                    throw new CodeError(cr, "Invalid type of parameter", "Got " + Lib_Par.objTypesToText(pars) + ", expected " + Lib_Par.typelistToText(types));
                }
            }
            ++i;
        }
        return pars;
    }

    public static I_Object[] checkParsFlex(CallRuntime cr, I_Object streamIt, I_Object[] eachIt, int par_min, int par_max) {
        I_Object[] pars = cr.getPars(streamIt, eachIt);
        int len = pars.length;
        Lib_Error.ifPars(len, par_min, par_max, cr.getDebugInfo());
        int i = 0;
        while (i < len) {
            pars[i] = Lib_Convert.getValue(cr, pars[i]);
            ++i;
        }
        return pars;
    }

    private static String objTypesToText(I_Object[] oa) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int ioa = 0;
        while (ioa < oa.length) {
            I_Object o = oa[ioa];
            if (ioa != 0) {
                sb.append(", ");
            }
            sb.append(o.getTypeName());
            ++ioa;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String typelistToText(Class<?> type) {
        return Lib_Type.getName(type, null);
    }

    private static String typelistToText(Class<?>[][] types) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int ica = 0;
        while (ica < types.length) {
            Class<?>[] ca = types[ica];
            if (ica != 0) {
                sb.append(", ");
            }
            if (ca.length > 1) {
                sb.append('[');
            }
            int i = 0;
            while (i < ca.length) {
                if (i != 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_Type.getName(ca[i], null));
                ++i;
            }
            if (ca.length > 1) {
                sb.append(']');
            }
            ++ica;
        }
        sb.append(")");
        return sb.toString();
    }
}

