/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmo_lang.dev.JMo_Object;
import org.jmo_lang.object.I_Object;

public class ClassFinder {
    private static ClassFinder singleton = null;
    private final String pack;
    private final HashMap<String, Class<?>> classes;

    public static ClassFinder getInstance(String pack) {
        if (singleton == null) {
            singleton = new ClassFinder(pack);
        }
        return singleton;
    }

    private ClassFinder(String pack) {
        this.pack = pack;
        try {
            this.classes = this.getClasses(this.pack);
        }
        catch (Exception e) {
            throw Err.exit(e);
        }
    }

    public Class<?> get(String name) {
        return this.classes.get(name);
    }

    public Collection<Class<?>> getAll() {
        return this.classes.values();
    }

    private void addItem(List<Class<?>> classes, String base, String line) throws ClassNotFoundException {
        String filename = line.substring(line.lastIndexOf(47) + 1);
        if (filename.endsWith(".class") && filename.startsWith("JMo_") && !filename.contains("$")) {
            String classline;
            Class<?> c;
            String dotline = line.substring(base.length());
            if (dotline.startsWith("/")) {
                dotline = dotline.substring(1);
            }
            if (I_Object.class.isAssignableFrom(c = Class.forName(classline = (dotline = dotline.replaceAll("[/]", ".")).substring(0, dotline.lastIndexOf(46)))) || JMo_Object.class.isAssignableFrom(c)) {
                classes.add(c);
            }
        }
    }

    private HashMap<String, Class<?>> getClasses(String pack) throws Exception {
        ArrayList classes = new ArrayList();
        try {
            CodeSource src = ClassFinder.class.getProtectionDomain().getCodeSource();
            if (src.getLocation().toString().toLowerCase().endsWith(".jar")) {
                this.getClassesFromJar2(classes);
            } else {
                this.getClassesDirect(classes);
            }
        }
        catch (Exception e) {
            Err.exit(e);
        }
        HashMap map = new HashMap();
        for (Class clazz : classes) {
            map.put(clazz.getSimpleName(), clazz);
        }
        return map;
    }

    private void getClassesDirect(List<Class<?>> classes) throws IOException, URISyntaxException, ClassNotFoundException {
        Enumeration<URL> eu = ClassFinder.class.getClassLoader().getResources("");
        while (eu.hasMoreElements()) {
            URI uri = eu.nextElement().toURI();
            Path myPath = Paths.get(uri);
            String base = myPath.toString();
            Stream<Path> walk = Files.walk(myPath, Integer.MAX_VALUE, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String line = ((Path)it.next()).toString();
                this.addItem(classes, base, line);
            }
            walk.close();
        }
    }

    private void getClassesFromJar2(List<Class<?>> classes) throws IOException, ClassNotFoundException {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(System.getProperty("path.separator"));
        ArrayList<String> scanned = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (scanned.indexOf(path) < 0) {
                scanned.add(path);
                File file = new File(path);
                if (file.isFile() && file.getName().startsWith("jmo")) {
                    ZipEntry e;
                    FileInputStream is = new FileInputStream(file);
                    ZipInputStream zip = new ZipInputStream(is);
                    while ((e = zip.getNextEntry()) != null) {
                        String name = e.getName();
                        this.addItem(classes, "", name);
                    }
                    zip.close();
                }
            }
            ++n2;
        }
    }
}

