/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.test;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.debug.Stopwatch;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmd_Data;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.MDir;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.sys.file.MFileSys;
import java.util.ArrayList;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class TestAll {
    private static final boolean STOP_AT_FAIL = true;
    private static final boolean HINTS = false;
    private static final DEBUG_LEVEL DEBUG = DEBUG_LEVEL.NO;

    public static void main(String[] args) {
        MOut.setDebug(DEBUG);
        try {
            Stopwatch clock = new Stopwatch();
            TestAll.start();
            clock.print();
        }
        catch (Throwable t) {
            Err.exit(t);
        }
    }

    private static void dir(String s) throws Exception {
        MDir o = new MDir(s);
        I_List<I_File> list = o.contentFilesWithSuffix("jmo");
        list.sort(new int[0]);
        MOut.debug(list);
        int fails = 0;
        ArrayList<String> failed = new ArrayList<String>();
        Stopwatch uhr = new Stopwatch();
        for (I_File d : list) {
            boolean tr = TestAll.test(d.getPathAbsolute());
            if (tr) continue;
            ++fails;
            failed.add(d.getName());
        }
        String stop = uhr.gStringMillisec();
        if (fails > 0) {
            MOut.text("\n--- Failed ---");
            for (String f : failed) {
                MOut.text(f);
            }
        }
        String result = "\nTesttime: " + stop + "\n" + "Result  : " + (fails == 0 ? "Passed" : "FAILED (" + fails + ")");
        MOut.text(result);
    }

    private static void start() throws Exception {
        String testdir = MFileSys.current().dir("test").dir("auto").getPathAbsolute();
        TestAll.dir(testdir);
    }

    private static boolean test(String s) throws Exception {
        MFile datei = new MFile(s);
        MFile output_test = new MFile("/tmp/jmo-test.txt");
        if (output_test.exists()) {
            output_test.delete();
        }
        MOut.text("===== " + s);
        Parser_App parser = new Parser_App();
        App app = parser.parseText("> setOutputFile(\"/tmp/jmo-test.txt\")");
        parser.parseFile(app, datei);
        try {
            app.exec(null);
        }
        catch (ErrorBase eb) {
            Err.exit(eb);
            return false;
        }
        I_File output_saved = datei.getDirectory().dirFlex("output").fileFlex(datei.getName(), "txt");
        if (!output_saved.exists() && output_test.exists()) {
            output_test.copy(output_saved);
        }
        if (!output_test.exists()) {
            return true;
        }
        String befehl = "diff " + output_saved.getPathAbsolute() + " " + output_test.getPathAbsolute();
        SysCmd_Data sysInfo = new SysCmd_Data();
        sysInfo.startDir.set(output_test.getDirectory());
        sysInfo.command.set(befehl);
        sysInfo.wait.set(true);
        boolean ok = true;
        try {
            new SysCmd().start(sysInfo);
        }
        catch (Exception f) {
            ok = false;
        }
        if (ok) {
            MOut.text("Check: OK");
            return true;
        }
        MOut.text("Check: FAIL");
        String befehl2 = "kdiff3 " + output_saved.getPathAbsolute() + " " + output_test.getPathAbsolute();
        SysCmd_Data sysInfo2 = new SysCmd_Data();
        sysInfo2.startDir.set(output_test.getDirectory());
        sysInfo2.command.set(befehl2);
        sysInfo2.wait.set(false);
        try {
            new SysCmd().start(sysInfo2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
        return false;
    }
}

