/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.sys.MOut;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_DecNumber;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.I_VarConst;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.mc.MC_THIS;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class VarEnv {
    private final VarEnv parent;
    private final String type;
    private HashMap<I_VarConst, Group2<Class<? extends I_Object>, I_Object>> list = null;

    public VarEnv(VarEnv parent, boolean isConst) {
        this.parent = parent;
        this.type = isConst ? "constant" : "variable";
    }

    public void describe(int left) {
        this.init();
        String space = Lib_Parser.space(left);
        for (Map.Entry<I_VarConst, Group2<Class<? extends I_Object>, I_Object>> g : this.list.entrySet()) {
            MOut.text(String.valueOf(space) + "  " + g.getKey() + " --> " + ((I_Object)g.getValue().o2).toString());
        }
        MOut.text(String.valueOf(space) + this.toString());
        MOut.text(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.text(String.valueOf(space) + "  nil");
        } else {
            this.parent.describe(left + 1);
        }
    }

    public I_Object get(CallRuntime cr, I_VarConst var) {
        this.init();
        if (this.list.containsKey(var)) {
            return (I_Object)this.list.get((Object)var).o2;
        }
        if (this.parent != null && this.parent.knows(var)) {
            return this.parent.get(cr, var);
        }
        throw new CodeError(cr, "Access to uninitialized " + this.type, var.getName());
    }

    public I_Object get(CallRuntime cr, I_VarConst var, I_Object ifNotSet) {
        this.init();
        return this.knows(var) ? this.get(cr, var) : ifNotSet;
    }

    public Class<? extends I_Object> getType(Var var) {
        Group2 g = this.list.getOrDefault(var, null);
        return g == null ? null : (Class)g.o1;
    }

    public boolean isInitialized(Var var) {
        return this.knows(var);
    }

    public boolean knows(I_VarConst var) {
        this.init();
        return this.list.containsKey(var) ? true : (this.parent != null ? this.parent.knows(var) : false);
    }

    public void remove(Var v) {
        if (this.list == null) {
            return;
        }
        this.list.remove(v);
    }

    public void set(CallRuntime cr, I_VarConst var, I_Object obj, boolean typesafe, boolean nilable, boolean convert) {
        this.init();
        if (obj == null) {
            throw new CodeError(cr, "No Object to set", var.getName());
        }
        if (!this.list.containsKey(var) && this.parent != null && this.parent.knows(var)) {
            this.parent.set(cr, var, obj, typesafe, nilable, convert);
            return;
        }
        Class<?> objType = obj.getClass();
        Class<?> safedType = null;
        if (this.list.containsKey(var)) {
            safedType = (Class<?>)this.list.get((Object)var).o1;
        }
        obj = Lib_Convert.getValue(cr, obj);
        if (var instanceof Const && this.list.get(var) != null) {
            throw new ExecError(cr, "Const already set", String.valueOf(var.getName()) + "=" + obj.toString());
        }
        if (!nilable && obj == Nil.NIL) {
            throw new ExecError(cr, "Assign Nil to a not nillable " + this.type, String.valueOf(var.getName()) + "=" + Nil.NIL.toString());
        }
        if (obj != null) {
            if (!this.list.containsKey(var)) {
                if (objType != Nil.class) {
                    safedType = objType;
                }
                if (safedType == MC_THIS.class) {
                    MOut.exit("Nicht typsicher!");
                }
            } else {
                Class defType = (Class)this.list.get((Object)var).o1;
                if (convert) {
                    obj = this.iConvert(defType, objType, obj);
                    objType = obj.getClass();
                }
                if (typesafe && objType != Nil.class && defType != null && defType != objType) {
                    throw new ExecError(cr, "Wrong type for " + this.type + "!", "(" + Lib_Type.getName(defType, null) + ") <-- (" + Lib_Type.getName(objType, obj) + ") " + obj);
                }
            }
        }
        this.list.put(var, new Group2<Class, I_Object>(safedType, obj));
    }

    public String toDebug(CallRuntime cr, I_VarConst var, String ifNotSet) {
        this.init();
        return this.list.containsKey(var) ? this.get(cr, var).toDebug(cr) : ifNotSet;
    }

    public String toString() {
        String sll = this.list == null ? "null" : "" + this.list.size();
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent;
        return "VarEnv (Size:" + sll + ")" + sp;
    }

    private void init() {
        if (this.list == null) {
            this.list = new HashMap();
        }
    }

    private I_Object iConvert(Class<? extends I_Object> defType, Class<? extends I_Object> objType, I_Object obj) {
        if (A_IntNumber.class.isAssignableFrom(defType) && A_DecNumber.class.isAssignableFrom(objType)) {
            if (defType == JMo_Byte.class) {
                return new JMo_Byte(((Number)((A_DecNumber)obj).getValue()).byteValue());
            }
            if (defType == JMo_Short.class) {
                return new JMo_Short(((Number)((A_DecNumber)obj).getValue()).shortValue());
            }
            if (defType == Int.class) {
                return new Int(((Number)((A_DecNumber)obj).getValue()).intValue());
            }
            if (defType == JMo_Long.class) {
                return new JMo_Long(((Number)((A_DecNumber)obj).getValue()).longValue());
            }
        }
        if (A_DecNumber.class.isAssignableFrom(defType) && A_IntNumber.class.isAssignableFrom(objType)) {
            if (defType == JMo_Float.class) {
                return new JMo_Float(((Number)((A_IntNumber)obj).getValue()).floatValue());
            }
            if (defType == Dec.class) {
                return new Dec(((Number)((A_IntNumber)obj).getValue()).doubleValue());
            }
        }
        return obj;
    }
}

