/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.error.Err;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.VarConstEnv;
import org.jmo_lang.tools.Lib_Exec;

public class Instance
extends A_EventObject
implements I_AutoBlockDo {
    private final Type type;
    private final App app;
    private final Call[] pars;
    private VarConstEnv main_env = null;

    public Instance(App app, Type type, Call[] pars) {
        this.type = type;
        this.app = app;
        this.pars = pars;
    }

    @Override
    public void init(CallRuntime cpOld) {
        CallRuntime cpNew = new CallRuntime(this, cpOld.call);
        this.main_env = cpNew.vce;
        I_Object[] parObjs = null;
        if (this.pars != null) {
            parObjs = new I_Object[this.pars.length];
            int i = 0;
            while (i < parObjs.length) {
                parObjs[i] = cpNew.execInit(this.pars[i], null);
                ++i;
            }
        } else {
            parObjs = new I_Object[]{};
        }
        this.type.getBlock().execTypeBlock(cpOld, cpNew, parObjs);
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cpOld, String method) {
        Function f = this.type.getFunctions().get(cpOld, method);
        CallRuntime cpNew = cpOld.copyVCE(this, this.main_env, true);
        try {
            return new ObjectCallResult(f.getBlock().execFunction(cpNew, f), f.hasAttachmentControl());
        }
        catch (ReturnException r) {
            Lib_Exec.checkIsReturn(cpNew, r);
            return new ObjectCallResult(r.get().getResult(), f.hasAttachmentControl());
        }
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return this.type.getEvents().knows(event.substring(1));
    }

    @Override
    public int compareTo(I_Object o) {
        throw Err.todo(o);
    }

    public App gApp() {
        return this.app == null ? (App)this : this.app;
    }

    public Type getType() {
        return this.type;
    }

    public VarConstEnv getMainEnv() {
        return this.main_env;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Instance(" + this.type.getName() + ")";
    }

    protected void setMainEnv(VarConstEnv vce) {
        if (this.main_env != null) {
            Err.forbidden("Is already set!");
        }
        this.main_env = vce;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        Call c2stream;
        if (this.type == null || this.type.getAutoBlockFunction() == null) {
            throw new ExecError(cr, "This type has no auto-block-function!", "Type: " + this.type.getName());
        }
        String newMethod = this.type.getAutoBlockFunction();
        Call call2 = new Call(cr.getSurrBlock(), this, newMethod, cr.call.parCalls, cr.getDebugInfo());
        Block c2block = cr.call.getBlock();
        if (c2block != null) {
            call2.setBlock(c2block);
        }
        if ((c2stream = cr.call.getStream()) != null) {
            call2.setStream(c2stream);
        }
        CallRuntime cpNew = cr.copyCall(call2, false);
        return this.callMethod((CallRuntime)cpNew, (String)newMethod).obj;
    }
}

