/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.FuncLet;
import org.jmo_lang.object.pseudo.I_ObjToReplace;
import org.jmo_lang.object.pseudo.MultiCall;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.pseudo.mc.MC_IT_BLOCK;
import org.jmo_lang.object.pseudo.mc.MC_IT_EACH;
import org.jmo_lang.object.pseudo.mc.MC_IT_STREAM;
import org.jmo_lang.object.pseudo.mc.MagicConst;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.StrictManager;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.struct.runtime.VarConstEnv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Par;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prio;

public class CallRuntime {
    public final Instance instance;
    public final Call call;
    public final VarConstEnv vce;
    public final Call funcCalledWith;
    private I_Object[] par_result = null;

    public CallRuntime(Instance instance, Call call) {
        this(instance, call, null, true, null);
    }

    private CallRuntime(Instance instance, Call call, VarConstEnv parentVCE, boolean varEnvNew, Call funcCalledWith) {
        this.instance = instance;
        this.call = call;
        this.funcCalledWith = funcCalledWith;
        this.vce = varEnvNew ? new VarConstEnv(parentVCE) : parentVCE;
    }

    public CallRuntime copyCall(Call call, boolean newVarEnv) {
        return new CallRuntime(this.instance, call, this.vce, newVarEnv, this.funcCalledWith);
    }

    public CallRuntime copyBlockItem(Call call) {
        return new CallRuntime(this.instance, call, this.vce, false, this.funcCalledWith);
    }

    public CallRuntime copyVCE(Instance newInstance, VarConstEnv base_vce, boolean varEnvNew) {
        return new CallRuntime(newInstance, this.call, base_vce, varEnvNew, this.funcCalledWith);
    }

    public CallRuntime copyLoop(Handle_Loop handle) {
        CallRuntime result = new CallRuntime(this.instance, this.call, this.vce, true, this.funcCalledWith);
        result.vce.loopSet(handle);
        return result;
    }

    public CallRuntime copyNil() {
        Call c = new Call(this.getSurrBlock(), Nil.NIL, this.getDebugInfo());
        return new CallRuntime(this.instance, c, this.vce, false, this.funcCalledWith);
    }

    public CallRuntime copyFunctional() {
        return new CallRuntime(this.instance, this.call, null, true, this.funcCalledWith);
    }

    public CallRuntime copyFunction() {
        return new CallRuntime(this.instance, this.call, this.instance.getMainEnv(), true, this.call);
    }

    public void describe(int left) {
        MOut.line(new Object[0]);
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "CurProc " + this.hashCode());
        space = Lib_Parser.space(++left);
        MOut.text(String.valueOf(space) + "Instance: " + this.instance.toDebug(this));
        MOut.text(String.valueOf(space) + "Call: " + (this.call == null ? "null" : this.call.toDebug(this)));
        if (this.call != null) {
            MOut.text(String.valueOf(space) + "SurrBlock: " + this.call.surrounding);
            MOut.text(String.valueOf(space) + "CallBlock: " + this.call.getBlock());
            MOut.text(String.valueOf(space) + "Vars (Types): ");
            if (this.getSurrBlock() != null && this.getSurrBlock().gVarManager() != null) {
                this.getSurrBlock().gVarManager().describe(left + 2);
            } else {
                MOut.text(String.valueOf(space) + "  none");
            }
        }
    }

    public App getApp() {
        return this.instance.gApp();
    }

    public Block getCallBlock() {
        return this.call.getBlock();
    }

    public DebugInfo getDebugInfo() {
        return this.call.debugInfo;
    }

    public Call getStream() {
        return this.call.getStream();
    }

    public Block getSurrBlock() {
        return this.call.surrounding;
    }

    public Type getType() {
        return this.instance.getType();
    }

    public StrictManager getStrict() {
        return this.instance.gApp().strict;
    }

    public int parCount() {
        return this.call.getParCount(this);
    }

    public I_Object[] pars(Class<?> result) {
        Lib_Par.checkBlock(this, result);
        return Lib_Par.checkPars(this, null, null, new Class[0]);
    }

    public I_Object[] pars(Class<?> result, I_Object itStream, Class<?> ... types) {
        Lib_Par.checkBlock(this, result);
        return Lib_Par.checkPars(this, itStream, null, types);
    }

    public I_Object[] parsExt(Class<?> result, I_Object itStream, Class<?>[] ... types) {
        Lib_Par.checkBlock(this, result);
        return Lib_Par.checkParsExt(this, itStream, types);
    }

    public I_Object[] parsEach(Class<?> result, I_Object itStream, I_Object[] itEach, Class<?> ... types) {
        Lib_Par.checkBlock(this, result);
        return Lib_Par.checkPars(this, itStream, itEach, types);
    }

    public I_Object[] parsBlockEach(I_Object itStream, I_Object[] itEach, Class<?> ... types) {
        return Lib_Par.checkPars(this, itStream, itEach, types);
    }

    public I_Object[] parsFlex(Class<?> result, I_Object itStream, int par_min) {
        return this.parsFlex(result, itStream, par_min, Integer.MAX_VALUE);
    }

    public I_Object[] parsFlex(Class<?> result, I_Object itStream, int par_min, int par_max) {
        Lib_Par.checkBlock(this, result);
        return Lib_Par.checkParsFlex(this, itStream, null, par_min, par_max);
    }

    public I_Object[] parsBlock() {
        return Lib_Par.checkPars(this, null, null, new Class[0]);
    }

    public I_Object[] parsBlock(I_Object itStream, Class<?> ... types) {
        return Lib_Par.checkPars(this, itStream, null, types);
    }

    public I_Object[] parsBlockFlex(I_Object itStream, int par_min, int par_max) {
        return Lib_Par.checkParsFlex(this, itStream, null, par_min, par_max);
    }

    public I_Object parsOneAdvance(Class<?> result, I_Object itStream, int parNr, Class<? extends I_Object> type) {
        Lib_Par.checkBlock(this, result);
        return Lib_Par.checkParAdvance(this, itStream, parNr, type);
    }

    public void blockNecessary() {
        Lib_Par.checkBlockNecessary(this);
    }

    public void blockForbidden() {
        Lib_Par.checkBlockForbidden(this);
    }

    public I_Object parType(I_Object par, Class<?> type) {
        return Lib_Par.checkPar(this, par, type);
    }

    public I_Object parTypeExt(I_Object par, Class<?> ... types) {
        return Lib_Par.checkParExt(this, par, types);
    }

    public I_Object exec(I_Object streamIt) {
        return (I_Object)this.exec((I_Object)streamIt, null, (byte)-1).o1;
    }

    private Group2<I_Object, Call> exec(I_Object streamIt, I_Object eachIt, byte leftprio) {
        try {
            I_Object with;
            Group2<I_Object, Call> res = null;
            I_Object objNew = this.call.object;
            I_Object i_Object = with = objNew != null ? objNew : streamIt;
            if (this.call.method == null && with instanceof A_Atomic && this.call.getBlock() == null) {
                if (this.call.getStream() != null) {
                    throw Err.invalid(this.call);
                }
                return new Group2<I_Object, Object>(with, null);
            }
            if (with instanceof I_ObjToReplace) {
                if (objNew instanceof MC_IT_STREAM) {
                    with = streamIt;
                }
                if (with instanceof MC_IT_BLOCK && (with = this.call.method != null && this.call.method.equals("=") ? this.call.surrounding : this.call.surrounding.getIt()) == null) {
                    with = Nil.NIL;
                }
                if (with instanceof MC_IT_EACH) {
                    if (eachIt == null) {
                        throw new CodeError(this, "Invalid call!", "This function currently doesn't support _EACH.");
                    }
                    with = eachIt;
                }
                if (with instanceof MagicConst) {
                    I_Object with_copy = with;
                    if ((with = ((MagicConst)with).get(this)) == null) {
                        throw new CodeError(this, "Invalid use of a magic constant!", with_copy.toString());
                    }
                }
            }
            if (with == null) {
                if (this.call.object == null) {
                    throw Err.invalid("Call without Object!", this.call.toDebug(this), this.getDebugInfo());
                }
                throw new CodeError(this, "Missing Object, nothing to work with", "Invalid use of MagicConst: " + this.call.object.toDebug(this));
            }
            if (with instanceof NonAtomic) {
                with = ((NonAtomic)with).create(this);
            }
            with.initOnce(this);
            boolean multicall = this.iHasMulticall(this.call.parCalls);
            if (!multicall) {
                res = this.execObject(with, leftprio);
            } else {
                Call[] pars = this.call.parCalls;
                int plen = pars.length;
                I_Object o = this.call.object != null ? this.call.object : with;
                I_Object[] parsResult = new I_Object[plen];
                int pp = 0;
                while (pp < pars.length) {
                    Call par = pars[pp];
                    if (par.object instanceof MultiCall) {
                        ((MultiCall)par.object).setStream(o);
                    }
                    CallRuntime cpPar = new CallRuntime(this.instance, par, this.vce, false, this.funcCalledWith);
                    parsResult[pp] = cpPar.exec(o);
                    ++pp;
                }
                res = new Group2<I_Object, Object>(this.iExecMultiCall(with, 0, parsResult), null);
            }
            return res;
        }
        catch (ErrorBase t) {
            throw t;
        }
        catch (Err_Runtime t) {
            MOut.error(t);
            String ste = this.stackTrace(t.getStackTrace()[1]);
            throw new ExecError(this, String.valueOf(t.getMessage()) + ste, ConvObject.toTextDebug(t.getDetails()));
        }
        catch (RuntimeException t) {
            String ste = this.stackTrace(t.getStackTrace()[0]);
            throw new ExecError(this, String.valueOf(t.getClass().getSimpleName()) + ste, t.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public Group2<I_Object, Call> execObject(I_Object with, byte leftprio) {
        if (this.call.method == null) {
            if (this.call.getBlock() != null) {
                this2 = Lib_Convert.getValue(this, with);
                if (this2 instanceof I_AutoBlockDo) {
                    this.getStrict().checkAutoBlock(this);
                    ab_result = ((I_AutoBlockDo)this2).autoBlockDo(this);
                    return new Group2<I_Object, Object>(ab_result, null);
                }
                throw new CodeError(this, "This type has no auto-block-function.", "Use it with a function, for example '.go': " + with.getTypeName());
            }
            return new Group2<I_Object, Object>(with, null);
        }
        next = this.call.getStream();
        while (next != null && Lib_Prio.streamPrio(this.call, next) && this.call.getParCount(this) == 1) {
            par = this.pars(null, with, new Class[]{I_Object.class})[0];
            streamPrioResult = this.execStream(par, next, leftprio == -1 ? this.call.prio : leftprio);
            this.par_result = new I_Object[]{(I_Object)streamPrioResult.o1};
            next = (Call)streamPrioResult.o2;
        }
        callResult = with.call(this);
        if (callResult.is_Attachment_Exec) {
            return new Group2<I_Object, Object>(callResult.obj, null);
        }
        method = this.call.method;
        currentresult = callResult.obj;
        if (this.call.getBlock() != null) {
            if (this.getType().getFunctions().knows(method) && (f = this.getType().getFunctions().get(this, method)).hasAttachmentControl()) {
                return new Group2<I_Object, Object>(currentresult, null);
            }
            if (currentresult instanceof I_AutoBlockDo) {
                this.getStrict().checkAutoBlockAfterFunc(this);
                call2 = new Call(this.getSurrBlock(), currentresult, "do", null, this.getDebugInfo());
                call2.setBlock(this.call.getBlock());
                if (this.call.getStream() != null) {
                    call2.setStream(this.call.getStream());
                }
                cpNew = this.copyCall(call2, false);
                currentresult.initOnce(cpNew);
                abResult = ((I_AutoBlockDo)currentresult).autoBlockDo(cpNew);
                return new Group2<I_Object, Object>(abResult, null);
            }
            throw Err.forbidden(new Object[]{"A function can't have a block without I_AutoBlockDo or hasAttachmentControl!"});
        }
        if (next != null) ** GOTO lbl43
        return new Group2<I_Object, Call>(currentresult, next);
lbl-1000:
        // 1 sources

        {
            if (leftprio > -1 && next.prio < this.call.prio) {
                return new Group2<I_Object, Call>(currentresult, next);
            }
            streamResult = this.execStream(currentresult, next, leftprio);
            next = (Call)streamResult.o2;
            currentresult = (I_Object)streamResult.o1;
lbl43:
            // 2 sources

            ** while (next != null)
        }
lbl44:
        // 1 sources

        return new Group2<I_Object, Call>(currentresult, next);
    }

    public Group2<I_Object, Call> execStream(I_Object streamIt, Call next, byte leftprio) {
        if (next == null) {
            return new Group2<I_Object, Object>(streamIt, null);
        }
        switch (next.method) {
            case "&&": {
                if (streamIt != Bool.FALSE) break;
                return new Group2<I_Object, Object>(streamIt, null);
            }
            case "||": {
                if (streamIt != Bool.TRUE) break;
                return new Group2<I_Object, Object>(streamIt, null);
            }
            case "!&&": {
                if (streamIt != Bool.FALSE) break;
                return new Group2<Bool, Object>(Bool.TRUE, null);
            }
            case "!||": {
                if (streamIt != Bool.TRUE) break;
                return new Group2<Bool, Object>(Bool.FALSE, null);
            }
        }
        CallRuntime crStream = new CallRuntime(this.instance, next, this.vce, false, this.funcCalledWith);
        return crStream.exec(streamIt, null, leftprio);
    }

    private I_Object iExecMultiCall(I_Object with, int ppos, I_Object[] current) {
        int len = current.length;
        if (ppos == len) {
            this.par_result = current;
            Group2<I_Object, Call> gr = this.execObject(with, (byte)-1);
            return (I_Object)gr.o1;
        }
        I_Object[] current2 = new I_Object[len];
        System.arraycopy(current, 0, current2, 0, len);
        if (current[ppos] instanceof MultiCall) {
            I_Object result = with;
            MultiCall curMC = (MultiCall)current[ppos];
            curMC.exec(this, this.getSurrBlock(), with);
            curMC.resetPointer();
            while (curMC.hasNext()) {
                current2[ppos] = curMC.getNext();
                result = this.iExecMultiCall(with, ppos + 1, current2);
                if (!(with instanceof Var)) continue;
                ((Var)with).let(this, this, result);
            }
            return result;
        }
        return this.iExecMultiCall(with, ppos + 1, current2);
    }

    public I_Object[] getPars(I_Object streamIt, I_Object[] eachIt) {
        if (this.par_result != null) {
            return this.par_result;
        }
        int len = this.call.parCalls == null ? 0 : this.call.parCalls.length;
        I_Object[] parsTemp = new I_Object[len];
        if (len > 0) {
            I_Object o = this.call.object != null ? this.call.object : streamIt;
            int pp = 0;
            while (pp < len) {
                if (eachIt == null) {
                    Call par = this.call.parCalls[pp];
                    CallRuntime cpPar = new CallRuntime(this.instance, par, this.vce, false, this.funcCalledWith);
                    parsTemp[pp] = cpPar.exec(o);
                } else {
                    if (this.call.parCalls[pp].object instanceof VarLet) {
                        throw new CodeError(this, "Invalid use of VarLet!", "This function doesn't accept a VarLet.");
                    }
                    if (this.call.parCalls[pp].object instanceof FuncLet) {
                        FuncLet fl = (FuncLet)this.call.parCalls[pp].object;
                        Call[] par_calls = new Call[eachIt.length];
                        int i = 0;
                        while (i < eachIt.length) {
                            par_calls[i] = new Call(this.getSurrBlock(), eachIt[i], this.getDebugInfo());
                            ++i;
                        }
                        Call c = new Call(this.getSurrBlock(), null, null, par_calls, this.getDebugInfo());
                        CallRuntime cpFL = this.copyCall(c, true);
                        parsTemp[pp] = fl.exec(cpFL);
                    } else {
                        Err.ifToSmall(1.0, eachIt.length);
                        I_Object eachItObj = eachIt[0];
                        if (eachIt.length > 1) {
                            ArrayList<I_Object> al = new ArrayList<I_Object>();
                            I_Object[] i_ObjectArray = eachIt;
                            int n = eachIt.length;
                            int n2 = 0;
                            while (n2 < n) {
                                I_Object eachIt2 = i_ObjectArray[n2];
                                al.add(eachIt2);
                                ++n2;
                            }
                            eachItObj = new JMo_List(al);
                        }
                        parsTemp[pp] = (I_Object)this.copyCall((Call)this.call.parCalls[pp], (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1).o1;
                    }
                }
                ++pp;
            }
        }
        this.par_result = parsTemp;
        return this.par_result;
    }

    public I_Object getParAdvance(I_Object streamIt, int parNr) {
        if (this.par_result == null) {
            I_Object o = this.call.object != null ? this.call.object : streamIt;
            return this.execInit(this.call.parCalls[parNr], o);
        }
        return this.par_result[parNr];
    }

    private String stackTrace(StackTraceElement st) {
        String ste;
        String string = ste = st.getFileName() == null ? "" : String.valueOf(st.getFileName()) + ":" + st.getLineNumber();
        if (ste.length() > 0) {
            ste = String.valueOf('(') + ste + ')';
        }
        return ste;
    }

    private boolean iHasMulticall(Call[] calls) {
        if (calls != null) {
            Call[] callArray = calls;
            int n = calls.length;
            int n2 = 0;
            while (n2 < n) {
                Call c = callArray[n2];
                if (c.object instanceof MultiCall) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String toString() {
        String sc = this.call == null ? "null" : this.call.toString();
        return sc + " | " + this.instance.toString() + " | " + this.vce.toString();
    }

    public I_Object execInit(Call call, I_Object streamIt) {
        CallRuntime cpInit = new CallRuntime(this.instance, call, this.vce, false, this.funcCalledWith);
        return cpInit.exec(streamIt);
    }
}

