/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.data.struct.set.MSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.dev.JMo_Sandbox;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Condition;
import org.jmo_lang.object.JMo_For;
import org.jmo_lang.object.JMo_Group;
import org.jmo_lang.object.JMo_If;
import org.jmo_lang.object.JMo_Java;
import org.jmo_lang.object.JMo_Random;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.JMo_Repeat;
import org.jmo_lang.object.JMo_Switch;
import org.jmo_lang.object.JMo_Table;
import org.jmo_lang.object.JMo_Timer;
import org.jmo_lang.object.JMo_Try;
import org.jmo_lang.object.JMo_While;
import org.jmo_lang.object.datetime.JMo_Date;
import org.jmo_lang.object.datetime.JMo_DateTime;
import org.jmo_lang.object.datetime.JMo_Time;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.filesys.JMo_PathList;
import org.jmo_lang.object.list.JMo_FunctionMap;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.list.JMo_Makro;
import org.jmo_lang.object.list.JMo_Map;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.pseudo.NonAtomicSelf;
import org.jmo_lang.object.sys.JMo_Cmd;
import org.jmo_lang.object.sys.JMo_Input;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.ClassFinder;
import org.jmo_lang.tools.Lib_Type;

public class ObjectManager {
    public static I_Object get(App app, String name, Call[] pars, DebugInfo debugInfo) {
        String[] stringArray = ATOMIC.ATOMIC_TYPENAMES;
        int n = ATOMIC.ATOMIC_TYPENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            if (name.equals(r)) {
                throw ObjectManager.atomic(name, debugInfo);
            }
            ++n2;
        }
        Class<? extends I_Object> c = ObjectManager.iAssignType(app, name, debugInfo);
        if (c != null) {
            return new NonAtomic(c, pars);
        }
        if (name.charAt(0) == 'J' && name.equals("Java")) {
            app.strict.checkSave(debugInfo, "Java");
            return new JMo_Java(pars, debugInfo);
        }
        Class<?> c2 = ObjectManager.getClass(name);
        if (c2 != null) {
            if (I_Object.class.isAssignableFrom(c2)) {
                return new NonAtomic(c2, pars);
            }
            return new NonAtomic(JMo_Sandbox.class, c2, pars);
        }
        Type t = app.getType().getType(name);
        if (t == null) {
            throw new ParseError("Unknown type", name, debugInfo);
        }
        return new NonAtomicSelf(t, pars);
    }

    public static Class<?> getClass(String search) {
        return ObjectManager.getClassFinder().get("JMo_" + search);
    }

    public static ArrayList<String> search(HintManager hm, String search) {
        MSet<String> set = new MSet<String>();
        Collection<Class<?>> l = ObjectManager.getClassFinder().getAll();
        for (Class<?> c : l) {
            String name = Lib_Type.getName(c, null);
            if (!name.startsWith(search)) continue;
            set.add(name);
        }
        Collection<String> hints = hm.searchTypes(search);
        set.addIfUnknown(hints);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(set);
        return result;
    }

    private static Class<? extends I_Object> iAssignType(App app, String name, DebugInfo debug) {
        switch (name) {
            case "Condition": {
                return JMo_Condition.class;
            }
            case "For": {
                return JMo_For.class;
            }
            case "Group": {
                return JMo_Group.class;
            }
            case "If": {
                return JMo_If.class;
            }
            case "Random": {
                return JMo_Random.class;
            }
            case "Range": {
                return JMo_Range.class;
            }
            case "Regex": {
                return JMo_Regex.class;
            }
            case "Repeat": {
                return JMo_Repeat.class;
            }
            case "Switch": {
                return JMo_Switch.class;
            }
            case "Table": {
                return JMo_Table.class;
            }
            case "Timer": {
                app.strict.checkSave(debug, "Timer");
                return JMo_Timer.class;
            }
            case "Try": {
                return JMo_Try.class;
            }
            case "While": {
                return JMo_While.class;
            }
            case "Date": {
                return JMo_Date.class;
            }
            case "DateTime": {
                return JMo_DateTime.class;
            }
            case "Time": {
                return JMo_Time.class;
            }
            case "Dir": {
                app.strict.checkSave(debug, "Dir");
                return JMo_Dir.class;
            }
            case "File": {
                app.strict.checkSave(debug, "File");
                return JMo_File.class;
            }
            case "Path": {
                app.strict.checkSave(debug, "Path");
                return JMo_Path.class;
            }
            case "PathList": {
                app.strict.checkSave(debug, "Path");
                return JMo_PathList.class;
            }
            case "FunctionMap": {
                return JMo_FunctionMap.class;
            }
            case "List": {
                return JMo_List.class;
            }
            case "Makro": {
                return JMo_Makro.class;
            }
            case "Map": {
                return JMo_Map.class;
            }
            case "Error": {
                return JMo_Error.class;
            }
            case "Cmd": {
                app.strict.checkSave(debug, "Cmd");
                return JMo_Cmd.class;
            }
            case "Input": {
                app.strict.checkSave(debug, "Input");
                return JMo_Input.class;
            }
        }
        return null;
    }

    private static ErrorBaseDebug atomic(String type, DebugInfo debugInfo) {
        return new ParseError("Atomic types cannot created via typename!", type, debugInfo);
    }

    private static ClassFinder getClassFinder() {
        return ClassFinder.getInstance("org.jmo_lang");
    }
}

