/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;

public class Function
extends A_Object {
    private final String name;
    private final Block block;
    private final boolean attachmentControl;
    private final FunctionPar[] pars;
    private final String returnType;
    private final boolean returnNil;
    private final Type typ;
    private boolean oneLine = false;

    public Function(Type typ, String name, FunctionPar[] pars, boolean attachmentControl, String returnType, boolean returnNil, DebugInfo debugInfo) {
        this.typ = typ;
        this.name = name;
        this.block = new Block(typ, this, typ.getBlock());
        this.pars = pars;
        if (pars != null) {
            FunctionPar[] functionParArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar par = functionParArray[n2];
                if (par.isConst) {
                    this.block.gConstManager().create(par.name, debugInfo, true);
                } else {
                    this.block.gVarManager().create(par.name, debugInfo, true);
                }
                ++n2;
            }
        }
        this.attachmentControl = attachmentControl;
        this.returnType = returnType;
        this.returnNil = returnNil;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "return": 
            case "<": 
            case "=": {
                return A_Object.stdResult(new Return(Return.LEVEL.RETURN, Lib_Exec.onePar(cr, this, method.equals("=") ? 1 : 0, method.equals("<") ? 0 : 1)));
            }
        }
        return null;
    }

    @Override
    public int compareTo(I_Object o) {
        throw Lib_Error.notAllowed(null);
    }

    @Override
    public void describe(CallRuntime cr, int depth) {
        this.block.describe(cr, depth);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean hasAttachmentControl() {
        return this.attachmentControl;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean getReturnNil() {
        return this.returnNil;
    }

    public Type getType() {
        return this.typ;
    }

    public FunctionPar[] getVars() {
        return this.pars;
    }

    public void setOneLine() {
        this.oneLine = true;
    }

    public boolean isOneLine() {
        return this.oneLine;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "Function: " + this.name + "\n" + this.block.toDebug(cr);
    }

    @Override
    public String toString() {
        return "Function: " + this.name + "\n" + this.block.toString();
    }
}

