/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.mc.MC_THIS;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ConstManager;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.VarManager;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class Block
extends A_Object {
    private static int counter = 0;
    private final int nr;
    private ArrayList<Call> items = null;
    private final Block parent;
    private final Function func;
    private final Type typ;
    private final VarManager vars;
    private final ConstManager consts;
    private I_Object blockIT = null;

    public Block(Type typ) {
        this(typ, null, null);
    }

    public Block(Type typ, Function func, Block parent) {
        this.typ = typ;
        this.func = func;
        this.parent = parent;
        this.nr = ++counter;
        this.vars = new VarManager(parent == null ? null : parent.gVarManager());
        this.consts = new ConstManager(parent == null ? null : parent.gConstManager());
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "=": {
                this.blockIT = cr.pars(Block.class, this, new Class[]{null})[0];
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    public final void add(Call m) {
        Err.ifNull(m);
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(m);
    }

    @Override
    public int compareTo(I_Object o) {
        throw Err.todo(o);
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        String space2 = Lib_Parser.space(left + 1);
        MOut.text(String.valueOf(space) + this.toDebug(cr));
        if (this.vars != null && this.vars.count() > 0) {
            MOut.text(String.valueOf(space2) + "Variables:");
            this.vars.describe(cr, left + 2);
        }
        if (this.consts != null && this.consts.count() > 0) {
            MOut.text(String.valueOf(space2) + "Constants:");
            this.consts.describe(cr, left + 2);
        }
        if (this.items != null && this.items.size() > 0) {
            MOut.text(String.valueOf(space2) + "Items:");
            for (Call c : this.items) {
                c.describe(cr, left + 2);
            }
        }
    }

    public final I_Object execAppRoot(CallRuntime cr) throws ReturnException {
        return this.iExec(cr, this.blockIT, true);
    }

    public final I_Object exec(CallRuntime cr, I_Object blockIT) throws ReturnException {
        return this.execExt(cr, blockIT);
    }

    public final I_Object execExt(CallRuntime cr, I_Object blockIT) throws ReturnException {
        cr = cr.copyCall(cr.call, true);
        return this.iExec(cr, blockIT, false);
    }

    public I_Object execFunction(CallRuntime cpOld, Function f) throws ReturnException {
        boolean throw_return;
        I_Object checkValue;
        I_Object returnValue;
        CallRuntime cpNew;
        block14: {
            if (!f.hasAttachmentControl() && cpOld.call.getBlock() != null) {
                throw new CodeError(cpOld, "No Block allowed", "This function doesn't allow a block: " + cpOld.call.toString());
            }
            cpNew = cpOld.copyFunction();
            this.iInitPars(cpOld, cpNew, f.getVars(), cpOld.getPars(null, null));
            returnValue = null;
            checkValue = null;
            throw_return = false;
            try {
                checkValue = returnValue = this.iExec(cpNew, Nil.NIL, false);
            }
            catch (ReturnException e) {
                Return r = e.get();
                returnValue = r;
                checkValue = r.getResult();
                throw_return = true;
                if (r.getLevel() == Return.LEVEL.RETURN) break block14;
                Err.todo(r);
            }
        }
        if (checkValue == null && this.isEmpty()) {
            checkValue = returnValue = Lib_AtomConv.getDefaultValue(f.getReturnType());
        }
        if (f.getReturnType() != null) {
            if (f.getReturnType().equals("Same")) {
                if (throw_return && checkValue != Nil.NIL && !(checkValue instanceof MC_THIS) && !(checkValue instanceof Instance)) {
                    throw new CodeError(cpNew, "Wrong Value for Return-Type 'Same'", "Got \"" + Lib_Type.getName(checkValue.getClass(), checkValue) + "\", need _THIS");
                }
                A_Object newValue = cpNew.instance;
                if (cpNew.instance instanceof App) {
                    newValue = new MC_THIS(cpNew.getType(), false);
                }
                returnValue = throw_return ? new Return(((Return)returnValue).getLevel(), newValue) : newValue;
            } else {
                String[] resultTypes = checkValue.getTypes();
                String resultType = Lib_Type.getName(checkValue.getClass(), checkValue);
                String wantedType = f.getReturnType();
                if (!Lib_Array.knows(resultTypes, wantedType)) {
                    if (resultType.equals("Nil")) {
                        if (!f.getReturnNil()) {
                            throw new CodeError(cpNew, "Invalid return value", "Return value is nil");
                        }
                    } else {
                        throw new CodeError(cpNew, "Wrong Return-Type", "Got \"" + resultType + "\", need \"" + wantedType + "\"");
                    }
                }
            }
        }
        if (throw_return) {
            throw new ReturnException((Return)returnValue);
        }
        return returnValue;
    }

    public void execTypeBlock(CallRuntime cpOld, CallRuntime cpNew1, I_Object[] pars) {
        CallRuntime cpNew2 = cpNew1.copyCall(cpNew1.call, false);
        this.iInitPars(cpOld, cpNew2, cpNew1.instance.getType().getVars(), pars);
        try {
            this.iExec(cpNew2, null, false);
        }
        catch (ReturnException e) {
            throw new CodeError(cpOld, "Invalid condition", "Return, Break & Continue in Type-Body is forbidden.");
        }
    }

    public ConstManager gConstManager() {
        return this.consts;
    }

    public Function getFunction() {
        return this.func;
    }

    public I_Object getIt() {
        return this.blockIT;
    }

    public Collection<Call> gItems() {
        return this.items;
    }

    public Block gParent() {
        return this.parent;
    }

    public Type gType() {
        return this.typ;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.size() == 0;
    }

    public VarManager gVarManager() {
        return this.vars;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "<Block_" + this.nr + ">";
    }

    @Override
    public String toString() {
        return "Block_" + this.nr;
    }

    private final I_Object iExec(CallRuntime cr, I_Object blockIT, boolean returnLast) throws ReturnException {
        this.blockIT = blockIT;
        if (this.items == null) {
            return null;
        }
        I_Object last_result = null;
        for (Call c : this.items) {
            I_Object result;
            CallRuntime cpCall = cr.copyBlockItem(c);
            last_result = result = cpCall.exec(blockIT);
            if (!(result instanceof Return)) continue;
            if (((Return)result).getLevel() != Return.LEVEL.EXIT) {
                throw new ReturnException((Return)result);
            }
            result = ((Return)result).getResult();
            cr.getApp().exit(cr.copyCall(new Call(cr.getSurrBlock(), result, cr.getDebugInfo()), false));
        }
        return returnLast ? last_result : this.blockIT;
    }

    private void iInitPars(CallRuntime cpOld, CallRuntime cpNew, FunctionPar[] fVCs, I_Object[] pars) {
        int pars2;
        int pars1 = pars == null ? 0 : pars.length;
        int n = pars2 = fVCs == null ? 0 : fVCs.length;
        if (pars1 > pars2) {
            throw new CodeError(cpOld, "Too much parameters", "Got " + pars1 + ", need " + pars2 + " parameter(s).");
        }
        if (fVCs != null) {
            Err.ifNull(new Object[]{pars});
            int i = 0;
            while (i < fVCs.length) {
                I_Object par;
                boolean useDefault;
                FunctionPar fPar = fVCs[i];
                boolean bl = useDefault = pars.length < i + 1;
                if (useDefault && fPar.defaultValue == null) {
                    throw new CodeError(cpOld, "Missing parameter or default value", "Got " + pars.length + ", need " + fVCs.length + " parameter(s).");
                }
                I_Object i_Object = par = useDefault ? fPar.defaultValue : Lib_Convert.getValue(cpOld, pars[i]);
                if (fPar.type != null && par != Nil.NIL && !par.getTypeName().equals(fPar.type) && !Lib_Array.knows(par.getTypes(), fPar.type)) {
                    throw new CodeError(cpOld, "Wrong type of parameter", "Got " + par.getTypeName() + ", need " + fPar.type);
                }
                if (fPar.isConst) {
                    Const con = (Const)this.consts.use(fPar.name);
                    con.set(cpOld, cpNew, par);
                } else {
                    Var var = (Var)this.vars.use(fPar.name);
                    var.let(cpOld, cpNew, par);
                }
                ++i;
            }
        }
    }
}

