/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.ParseTimeSwitches;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.Parser_EventHead;
import org.jmo_lang.parser.Parser_Function;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.Parser_Type;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Event;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.Type;
import org.jmo_lang.tools.LineBuffer;

public class Parser_Block {
    private Call last = null;
    private boolean header_switches_ok = true;

    public void parse(App app, Type currentType, Function currentFunction, Block currentBlock, LineBuffer buffer, boolean root) {
        ParseTimeSwitches pts = new ParseTimeSwitches();
        while (buffer.hasNext()) {
            int nextLevelDiff = buffer.nextLevelDiff();
            if (nextLevelDiff < 0) {
                buffer.levelDownchanged();
                return;
            }
            if (nextLevelDiff > 1) {
                throw new ParseError("To much indents for the new blocklevel", "Got " + nextLevelDiff + " Tabs, 1 allowed", buffer.gDebugInfo());
            }
            String s = buffer.getNext().trim();
            if (s.length() > 0 && s.charAt(0) == '>') {
                if (!root) {
                    throw new ParseError("Invalid use of parsetime-switch!", "It can only be used at the root-level.", buffer.gDebugInfo());
                }
                if (!this.header_switches_ok) {
                    throw new ParseError("Invalid use of parsetime-switch!", "It can only be used at the top of the script.", buffer.gDebugInfo());
                }
                pts.parse(app, s, buffer.gDebugInfo());
                while (app.importsHasToParse()) {
                    app.strict.setAnotherScript();
                    I_File file = app.importsNext();
                    try {
                        String read = Lib_TextFile.read(file.getFile(), true);
                        Parser_Script ps = new Parser_Script(app, file.getName(), read);
                        ps.parse();
                    }
                    catch (Err_FileSys e) {
                        throw new ParseError("Include-Error!", e.getMessage(), buffer.gDebugInfo());
                    }
                }
                continue;
            }
            if (s == null || s.length() <= 0) continue;
            this.header_switches_ok = false;
            this.parseTypeFunc(app, currentType, currentFunction, currentBlock, buffer, s, true);
        }
    }

    private Call parseCall(App app, Block pc, String s, DebugInfo debugInfo) {
        Err.ifNull(pc, s);
        return Parser_Call.parseCall(app, pc, s, debugInfo);
    }

    private void parseTypeFunc(App app, Type currentType, Function currentFunction, Block currentBlock, LineBuffer buffer, String s, boolean isLastInLine) {
        if ((s = s.trim()).length() == 0) {
            return;
        }
        if (s.charAt(0) == ':') {
            char ch1 = (s = s.substring(1).trim()).charAt(0);
            if (ch1 >= 'A' && ch1 <= 'Z') {
                MOut.debug("New Type " + s);
                Parser_Type.parse(app, currentType, buffer, s);
                return;
            }
            if (ch1 >= 'a' && ch1 <= 'z') {
                MOut.debug("New Function " + s);
                Parser_Function.parse(app, currentType, buffer, s);
                return;
            }
            if (ch1 == '@') {
                MOut.debug("New Event " + s);
                Event ev = Parser_EventHead.parse(currentType, s);
                currentType.getEvents().add(ev.gName().substring(1), ev);
                if (buffer.nextLevelDiff() > 0) {
                    throw new ParseError("No Block allowed for Event-Definition", s, buffer.gDebugInfo());
                }
                return;
            }
        }
        Call c = this.parseCall(app, currentBlock, s, buffer.gDebugInfo());
        if (this.last == null) {
            currentBlock.add(c);
        } else {
            switch (s.trim().charAt(0)) {
                case '*': 
                case '+': 
                case ',': 
                case '.': 
                case '/': 
                case ']': {
                    this.last.setStream(c);
                    break;
                }
                default: {
                    currentBlock.add(c);
                }
            }
        }
        this.last = c.searchLastCall();
        if (isLastInLine && buffer.nextLevelDiff() > 0) {
            Parser_Block pb = new Parser_Block();
            Block b = new Block(currentType, currentFunction, currentBlock);
            this.last.setBlock(b);
            pb.parse(app, currentType, currentFunction, b, buffer, false);
            return;
        }
    }
}

