/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.pseudo.mc;

import de.mn77.base.error.Err;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Block;
import org.jmo_lang.object.Handle_Stream;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.pseudo.I_ObjToReplace;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Info;

public class MagicConst
extends A_Object
implements I_ObjToReplace {
    private final MAGICCONST type;

    public MagicConst(MAGICCONST type) {
        this.type = type;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        return new ObjectCallResult(null, false);
    }

    public I_Object get(CallRuntime cr) {
        switch (this.type) {
            case LINE: {
                return cr.getDebugInfo().getLine();
            }
            case FILE: {
                return cr.getDebugInfo().getFile();
            }
            case ARGS: {
                return cr.getApp().getArgs();
            }
            case APP: {
                return cr.getApp();
            }
            case FUNC: {
                return cr.getSurrBlock().getFunction();
            }
            case LOOP: {
                return cr.vce.loopGet(cr);
            }
            case BLOCK: {
                return new Handle_Block();
            }
            case STREAM: {
                return new Handle_Stream();
            }
            case DEVELOPERS: {
                return Lib_Info.developers(cr);
            }
            case SUPPORTERS: {
                return Lib_Info.supporters(cr);
            }
            case SPONSORS: {
                return Lib_Info.sponsors(cr);
            }
        }
        throw Err.impossible(new Object[]{this.type});
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "MagicConst(_" + (Object)((Object)this.type) + ")";
    }

    @Override
    public String toString() {
        return "_" + (Object)((Object)this.type);
    }

    public static enum MAGICCONST {
        LINE,
        FILE,
        ARGS,
        APP,
        FUNC,
        LOOP,
        BLOCK,
        STREAM,
        DEVELOPERS,
        SUPPORTERS,
        SPONSORS;

    }
}

