/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.pseudo;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ObjectManager;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class ObjectSearch
extends A_Object {
    private final HintManager hm;
    private final String search;
    private final boolean constructors;

    public ObjectSearch(HintManager hm, String s, boolean constructors) {
        this.hm = hm;
        this.search = s;
        this.constructors = constructors;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "list": {
                return A_Object.stdResult(this.iGetList(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object print(CallRuntime cr, boolean newline) {
        this.iShow(cr);
        return this;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "\"" + this.search + "\"?";
    }

    private JMo_List iGetList(CallRuntime cr) {
        cr.pars(JMo_List.class);
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        ArrayList<String> objs = this.iGetStrings(cr);
        for (String s : objs) {
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    private ArrayList<String> iGetObjects() {
        ArrayList<String> objs = ObjectManager.search(this.hm, this.search);
        Collections.sort(objs);
        return objs;
    }

    private ArrayList<String> iGetPars(CallRuntime cr) {
        Class<?> cl = ObjectManager.getClass(this.search);
        if (cl == null) {
            throw new CodeError(cr, "Unknown Object-Type", this.search);
        }
        Constructor<?>[] con = cl.getConstructors();
        ArrayList<String> al = new ArrayList<String>();
        Constructor<?>[] constructorArray = con;
        int n = con.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> co = constructorArray[n2];
            Class<?>[] pars = co.getParameterTypes();
            String pars2 = Lib_Convert.typelistToText(pars);
            al.add(String.valueOf(this.search) + pars2);
            ++n2;
        }
        return al;
    }

    private String iGetString(CallRuntime cr) {
        ArrayList<String> als = this.iGetStrings(cr);
        CharSequence[] sa = als.toArray(new String[als.size()]);
        return String.join((CharSequence)"\n", sa);
    }

    private ArrayList<String> iGetStrings(CallRuntime cr) {
        return this.constructors ? this.iGetPars(cr) : this.iGetObjects();
    }

    private void iShow(CallRuntime cr) {
        String res = this.iGetString(cr);
        Lib_Output.out(cr.getApp(), res, true);
    }
}

