/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.pseudo;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.form.FormText;
import de.mn77.base.error.I_Error;
import org.jmo_lang.error.CustomError;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Error
extends A_Object {
    private final Throwable ex;
    private final ParCallBuffer par1;
    private final ParCallBuffer par2;

    public JMo_Error(Throwable t) {
        this.ex = t;
        this.par1 = null;
        this.par2 = null;
    }

    public JMo_Error(Call par1, Call par2) {
        this.ex = new Throwable();
        this.par1 = new ParCallBuffer(par1);
        this.par2 = new ParCallBuffer(par2);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par1 != null) {
            this.par1.init(cr, this, Str.class);
        }
        if (this.par2 != null) {
            this.par2.init(cr, this, Str.class);
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "do": 
            case "throw": {
                this.iThrow(cr);
                return new ObjectCallResult(Nil.NIL, true);
            }
            case "show": {
                return A_Object.stdResult(this.show(cr));
            }
            case "getMessage": {
                cr.pars(Str.class);
                return A_Object.stdResult(new Str(this.ex.getLocalizedMessage()));
            }
            case "getSource": {
                cr.pars(Str.class);
                return this.ex instanceof ErrorBaseDebug ? A_Object.stdResult(new Str(((ErrorBaseDebug)this.ex).getSource())) : A_Object.stdResult(Nil.NIL);
            }
            case "getCall": {
                cr.pars(Str.class);
                return this.ex instanceof ErrorBaseDebug ? A_Object.stdResult(new Str(((ErrorBaseDebug)this.ex).getCall())) : A_Object.stdResult(Nil.NIL);
            }
            case "getDetail": {
                cr.pars(Str.class);
                return this.ex instanceof ErrorBaseDebug ? A_Object.stdResult(new Str(((ErrorBaseDebug)this.ex).getDetail())) : A_Object.stdResult(Nil.NIL);
            }
            case "getInstance": {
                cr.pars(Str.class);
                return this.ex instanceof ErrorBaseDebug ? A_Object.stdResult(new Str(((ErrorBaseDebug)this.ex).getInstance())) : A_Object.stdResult(Nil.NIL);
            }
            case "getGroup": {
                cr.pars(Str.class);
                return A_Object.stdResult(new Str(((ErrorBaseDebug)this.ex).getGroup().title));
            }
        }
        return null;
    }

    private void iThrow(CallRuntime cr) {
        if (this.par1 != null && this.par2 != null) {
            throw new CustomError(cr, FormText.unquote(this.par1.toString()), FormText.unquote(this.par2.toString()));
        }
        throw new CustomError(cr, "Thrown again", this.iMessageToString(false));
    }

    public I_Object show(CallRuntime cr) {
        cr.pars(JMo_Error.class);
        String s = "Error " + this.iMessageToString(true);
        Lib_Output.out(cr.getApp(), s, true);
        return this;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        if (this.par1 != null && this.par2 != null) {
            return "Error(" + this.par1.toDebug(cr) + "," + this.par2.toDebug(cr) + ")";
        }
        return "Error " + this.iMessageToString(false);
    }

    @Override
    public String toString() {
        if (this.par1 != null && this.par2 != null) {
            return "Error(" + this.par1.toString() + "," + this.par2.toString() + ")";
        }
        return "Error " + this.iMessageToString(false);
    }

    private String iMessageToString(boolean details) {
        String s;
        String message = this.ex.getLocalizedMessage();
        String string = s = message != null ? ": " + message : ": Unknown";
        if (!details) {
            return s;
        }
        if (this.ex instanceof I_Error) {
            for (Object o : ((I_Error)((Object)this.ex)).getDetails()) {
                s = String.valueOf(s) + "\n" + ConvObject.toText(o);
            }
        }
        return s;
    }
}

