/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.passthrough;

import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.passthrough.I_PassThrough;
import org.jmo_lang.object.passthrough.I_VarConst;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;

public class Var
extends A_EventObject
implements I_PassThrough,
I_VarConst {
    private final String name;
    private final boolean nilable;
    private final boolean typesafe;

    public Var(String name) {
        Err.ifNull(name);
        this.name = name;
        this.typesafe = !name.endsWith("\u00bf") && !name.endsWith("??");
        this.nilable = !this.typesafe || name.endsWith("?");
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "=": 
            case "let": {
                I_Object streamit = cr.vce.vars.get(cr, this, null);
                I_Object par = cr.pars(null, streamit, I_Object.class)[0];
                this.let(cr, cr, par);
                return A_Object.stdResult(this);
            }
            case "convertLet": {
                I_Object streamit2 = cr.vce.vars.get(cr, this, null);
                I_Object par2 = cr.pars(null, streamit2, I_Object.class)[0];
                this.iSet(cr, cr, par2, true);
                return A_Object.stdResult(this);
            }
        }
        return this.iCallValue(cr, method);
    }

    @Override
    public ObjectCallResult callEvent(CallRuntime cr, String event) {
        throw new CodeError(cr, "Invalid call of a event", "Got: " + event);
    }

    public I_Object get(CallRuntime cr) {
        return cr.vce.vars.get(cr, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public I_Object print(CallRuntime cr, boolean newline) {
        this.get(cr);
        return super.print(cr, newline);
    }

    public void let(CallRuntime cpOld, CallRuntime cpNew, I_Object o) {
        this.iSet(cpOld, cpNew, o, false);
    }

    private void iSet(CallRuntime cpOld, CallRuntime cpNew, I_Object o, boolean convert) {
        cpNew.vce.vars.set(cpOld, this, o, this.typesafe, this.nilable, convert);
        this.eventRun(cpNew, "@varChanged", o);
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return event.equals("@varChanged");
    }

    @Override
    public String toDebug(CallRuntime cr) {
        Err.ifNull(cr);
        String val = cr.vce.vars.isInitialized(this) ? cr.vce.vars.get(cr, this).toDebug(cr) : "";
        return String.valueOf(this.name) + "(" + val + ")";
    }

    @Override
    public String toString() {
        return this.name;
    }

    private ObjectCallResult iCallValue(CallRuntime cr, String method) {
        ObjectCallResult result = this.get(cr).call(cr);
        if (result == null || result.obj == null) {
            Err.invalid("Call returns no result!");
        }
        switch (method) {
            case "**": 
            case "++": 
            case "--": 
            case "//": {
                I_Object valueCopy = this.get(cr);
                Call callToSet = new Call(cr.getSurrBlock(), valueCopy, method, cr.call.parCalls, cr.getDebugInfo());
                ObjectCallResult result2 = valueCopy.call(cr.copyCall(callToSet, false));
                if (result2.is_Attachment_Exec) {
                    Err.invalid(method, result, result2, this);
                }
                this.iSet(cr, cr, result2.obj, true);
            }
        }
        return result;
    }
}

