/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_PathList
extends A_Object
implements I_AutoBlockDo,
I_AutoBlockList {
    private final ParCallBuffer files;
    private String search = null;

    public JMo_PathList(Call files) {
        this.files = new ParCallBuffer(files);
    }

    @Override
    public void init(CallRuntime cr) {
        this.search = Lib_Convert.getStringValue(cr, this.files.init(cr, this, Str.class));
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "do": 
            case "each": {
                return this.each(cr, false);
            }
            case "toList": 
            case "get": {
                return this.each(cr, true);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr, (boolean)false).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        return ((JMo_List)this.each((CallRuntime)cr, (boolean)true).obj).getInternalObject();
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "PathList(" + this.files + ")";
    }

    private ObjectCallResult each(CallRuntime cpOld, boolean toList) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, toList ? 0 : 1);
        BlockExecArgs args = new BlockExecArgs(pars);
        DirectoryStream<Path> content = this.searchFiles(cpOld);
        JMo_PathList res = this;
        ArrayList<I_Object> list = toList ? new ArrayList<I_Object>() : null;
        CallRuntime cpNew = cpOld.copyLoop(new Handle_Loop(this));
        for (Path d : content) {
            A_FileSys it;
            File file = d.toFile();
            A_FileSys a_FileSys = it = file.isDirectory() ? new JMo_Dir(file) : new JMo_File(file);
            if (toList) {
                list.add(it);
                continue;
            }
            Lib_Exec.execBlock(cpNew, args, it);
        }
        return toList ? new ObjectCallResult(new JMo_List(list), false) : new ObjectCallResult(res, true);
    }

    private DirectoryStream<Path> searchFiles(CallRuntime cr) {
        String search;
        String regex = "(.*)" + Sys.getSeperatorDir() + "(.*)";
        String path = this.search.replaceFirst(regex, "$1");
        if (path.equals(search = this.search.replaceFirst(regex, "$2"))) {
            path = "";
        }
        try {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path, new String[0]), search);
            return dirStream;
        }
        catch (IOException e) {
            throw new ExtError(cr, "In/Out-Error", e.getMessage());
        }
    }
}

