/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.datetime;

import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.error.Err;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.runtime.CallRuntime;

public class Lib_DateTime_Format {
    public static Str format(CallRuntime cr, String format, I_Date date, I_Time time) {
        StringBuilder sb = new StringBuilder();
        while (format.length() > 0) {
            int move = 0;
            if (format.charAt(0) == '~' && format.length() > 1) {
                sb.append(format.charAt(1));
                move = 2;
            }
            if (move == 0 && date != null) {
                move = Lib_DateTime_Format.formatDate(sb, format, date);
            }
            if (move == 0 && time != null) {
                move = Lib_DateTime_Format.formatTime(sb, format, time);
            }
            if (move == 0) {
                sb.append(format.charAt(0));
                move = 1;
            }
            Err.ifEqual(move, 0);
            format = format.substring(move);
        }
        return new Str(sb.toString());
    }

    private static int formatDate(StringBuilder sb, String format, I_Date date) {
        int move = 0;
        if (format.startsWith("YYYY")) {
            sb.append(FormNumber.width(4, date.getYear(), false));
            move = 4;
        } else if (format.startsWith("YY")) {
            String tmp = "" + date.getYear();
            if (tmp.length() >= 2) {
                sb.append(tmp.substring(tmp.length() - 2, tmp.length()));
            } else {
                sb.append(FormNumber.width(2, tmp, false));
            }
            move = 2;
        } else if (format.startsWith("Y")) {
            sb.append("" + date.getYear());
            move = 1;
        } else if (format.startsWith("MM")) {
            sb.append(FormNumber.width(2, date.getMonth(), false));
            move = 2;
        } else if (format.startsWith("M")) {
            sb.append("" + date.getMonth());
            move = 1;
        } else if (format.startsWith("DD")) {
            sb.append(FormNumber.width(2, date.getDay(), false));
            move = 2;
        } else if (format.startsWith("D")) {
            sb.append("" + date.getDay());
            move = 1;
        }
        return move;
    }

    private static int formatTime(StringBuilder sb, String format, I_Time time) {
        int move = 0;
        if (format.startsWith("hh")) {
            sb.append(FormNumber.width(2, time.getHours(), false));
            move = 2;
        } else if (format.startsWith("h")) {
            sb.append("" + time.getHours());
            move = 1;
        } else if (format.startsWith("mm")) {
            sb.append(FormNumber.width(2, time.getMinutes(), false));
            move = 2;
        } else if (format.startsWith("m")) {
            sb.append("" + time.getMinutes());
            move = 1;
        } else if (format.startsWith("ss")) {
            sb.append(FormNumber.width(2, time.getSeconds(), false));
            move = 2;
        } else if (format.startsWith("s")) {
            sb.append("" + time.getSeconds());
            move = 1;
        }
        return move;
    }
}

