/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.datetime;

import de.mn77.base.data.constant.DATE;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.datetime.A_DateTimeBase;
import org.jmo_lang.object.datetime.JMo_Date;
import org.jmo_lang.object.datetime.JMo_DateTime;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Time
extends A_DateTimeBase {
    private I_Time time = null;
    private final Call[] init;

    public JMo_Time(I_Time time) {
        this.init = null;
        this.time = time;
    }

    public JMo_Time() {
        this.init = null;
    }

    public JMo_Time(Call str) {
        this.init = new Call[]{str};
    }

    public JMo_Time(Call h, Call m) {
        this.init = new Call[]{h, m};
    }

    public JMo_Time(Call h, Call m, Call s) {
        this.init = new Call[]{h, m, s};
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.time != null) {
            return;
        }
        if (this.init == null) {
            this.time = new MTime();
        } else if (this.init.length == 1) {
            I_Object o = cr.execInit(this.init[0], null);
            if (o instanceof A_IntNumber) {
                int ih = Lib_Convert.getIntValue(cr, o);
                try {
                    this.time = new MTime(ih, 0, 0);
                }
                catch (Err_Runtime err) {
                    throw new ExecError(cr, "Invalid time", "Time(" + ih + ")");
                }
            } else {
                String s = Lib_Convert.getStringValue(cr, o);
                try {
                    this.time = new MTime(s);
                }
                catch (Err_Runtime err) {
                    throw new ExecError(cr, "Invalid time", "Time(" + s + ")");
                }
            }
        } else {
            if (this.init.length == 2) {
                int ih = Lib_Convert.getIntValue(cr, cr.execInit(this.init[0], null));
                int im = Lib_Convert.getIntValue(cr, cr.execInit(this.init[1], null));
                try {
                    this.time = new MTime(ih, im, 0);
                }
                catch (Err_Runtime err) {
                    throw new ExecError(cr, "Invalid time", "Time(" + ih + "," + im + ")");
                }
            }
            int ih = Lib_Convert.getIntValue(cr, cr.execInit(this.init[0], null));
            int im = Lib_Convert.getIntValue(cr, cr.execInit(this.init[1], null));
            int is = Lib_Convert.getIntValue(cr, cr.execInit(this.init[2], null));
            try {
                this.time = new MTime(ih, im, is);
            }
            catch (Err_Runtime err) {
                throw new ExecError(cr, "Invalid time", "Time(" + ih + "," + im + "," + is + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.getHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.getMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.getSeconds(cr));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.add(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.addsubMinutes(cr, true));
            }
            case "addHours": {
                return A_Object.stdResult(this.addsubHours(cr, true));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.sub(cr, true));
            }
            case "subMin": 
            case "subMinutes": {
                return A_Object.stdResult(this.addsubMinutes(cr, false));
            }
            case "subHours": {
                return A_Object.stdResult(this.addsubHours(cr, false));
            }
            case "setHours": 
            case "setHour": {
                return A_Object.stdResult(this.setHour(cr));
            }
            case "setMinutes": 
            case "setMinute": {
                return A_Object.stdResult(this.setMinute(cr));
            }
            case "setSecond": 
            case "setSeconds": {
                return A_Object.stdResult(this.setSecond(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.diffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.diffMinutes(cr));
            }
            case "diffSeconds": {
                return A_Object.stdResult(this.diffSeconds(cr));
            }
        }
        return null;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        if (this.time == null) {
            return "Time";
        }
        return "Time(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.time == null) {
            return "Time";
        }
        return this.time.toString();
    }

    @Override
    protected boolean[] compare2(CallRuntime cr) {
        JMo_Time other = (JMo_Time)cr.pars(Bool.class, this, JMo_Time.class)[0];
        boolean isEqual = this.time.isEqual(other.getInternalValue());
        boolean isGreater = this.time.isGreater(other.getInternalValue());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object par) {
        return par instanceof JMo_Time ? this.time.isEqual(((JMo_Time)par).getInternalTime()) : false;
    }

    private Int diffSeconds(CallRuntime cr) {
        JMo_Time par = (JMo_Time)cr.pars(Int.class, this, JMo_Time.class)[0];
        int diff = this.time.diffSeconds(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffMinutes(CallRuntime cr) {
        JMo_Time par = (JMo_Time)cr.pars(Int.class, this, JMo_Time.class)[0];
        int diff = this.time.diffMinutes(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffHours(CallRuntime cr) {
        JMo_Time par = (JMo_Time)cr.pars(Int.class, this, JMo_Time.class)[0];
        int diff = this.time.diffHours(par.getInternalValue());
        return new Int(diff);
    }

    private Int getSeconds(CallRuntime cr) {
        cr.pars(Int.class);
        return new Int(this.time.getSeconds());
    }

    private Int getMinutes(CallRuntime cr) {
        cr.pars(Int.class);
        return new Int(this.time.getMinutes());
    }

    private Int getHours(CallRuntime cr) {
        cr.pars(Int.class);
        return new Int(this.time.getHours());
    }

    private I_Object add(CallRuntime cr, boolean seconds) {
        I_Object par;
        I_Object i_Object = par = seconds ? cr.pars(JMo_Time.class, this, A_IntNumber.class)[0] : cr.parsExt(null, this, new Class[][]{{A_IntNumber.class, A_DateTimeBase.class}})[0];
        if (par instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, par);
            I_Time date2 = this.time.getAddSeconds(pari);
            return new JMo_Time(date2);
        }
        if (par instanceof JMo_Time) {
            I_Time part = ((JMo_Time)par).getInternalTime();
            I_Time temp = this.time;
            temp = temp.getAddHours(part.getHours());
            temp = temp.getAddMinutes(part.getMinutes());
            temp = temp.getAddSeconds(part.getSeconds());
            return new JMo_Time(temp);
        }
        if (par instanceof JMo_Date) {
            I_Date d = ((JMo_Date)par).getInternalDate();
            MDateTime dt = new MDateTime(d, this.time);
            return new JMo_DateTime(dt);
        }
        if (par instanceof JMo_DateTime) {
            I_DateTime temp = ((JMo_DateTime)par).getInternalDateTime();
            temp = temp.getAddHours(this.time.getHours());
            temp = temp.getAddMinutes(this.time.getMinutes());
            temp = temp.getAddSeconds(this.time.getSeconds());
            return new JMo_DateTime(temp);
        }
        throw Err.impossible(par.getClass().getSimpleName());
    }

    private JMo_Time sub(CallRuntime cr, boolean seconds) {
        I_Object par;
        I_Object i_Object = par = seconds ? cr.pars(JMo_Time.class, this, A_IntNumber.class)[0] : cr.parsExt(JMo_Time.class, this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (par instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, par);
            I_Time date2 = this.time.getAddSeconds(-pari);
            return new JMo_Time(date2);
        }
        if (par instanceof JMo_Time) {
            I_Time part = ((JMo_Time)par).getInternalTime();
            I_Time temp = this.time;
            temp = temp.getAddHours(-part.getHours());
            temp = temp.getAddMinutes(-part.getMinutes());
            temp = temp.getAddSeconds(-part.getSeconds());
            return new JMo_Time(temp);
        }
        throw Err.impossible(par.getClass().getSimpleName());
    }

    private JMo_Time addsubMinutes(CallRuntime cr, boolean add) {
        I_Object par = cr.pars(JMo_Date.class, this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, par);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddMinutes(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time addsubHours(CallRuntime cr, boolean add) {
        I_Object par = cr.pars(JMo_Date.class, this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, par);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddHours(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time setHour(CallRuntime cr) {
        I_Object par = cr.pars(JMo_Date.class, this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, par);
        I_Time time2 = this.time.getSetHour(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time setMinute(CallRuntime cr) {
        I_Object par = cr.pars(JMo_Date.class, this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, par);
        I_Time time2 = this.time.getSetMinute(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time setSecond(CallRuntime cr) {
        I_Object par = cr.pars(JMo_Date.class, this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, par);
        I_Time time2 = this.time.getSetSecond(pari);
        return new JMo_Time(time2);
    }

    @Override
    protected JMo_Time incdec2(boolean inc, int amount) {
        if (inc) {
            I_Time date2 = this.time.getAddSeconds(amount);
            return new JMo_Time(date2);
        }
        I_Time date2 = this.time.getAddSeconds(-amount);
        return new JMo_Time(date2);
    }

    @Override
    protected JMo_Time limit(CallRuntime cr) {
        I_Object[] pars = cr.pars(DATE.class, this, JMo_Time.class, JMo_Time.class);
        I_Time min = ((JMo_Time)pars[0]).time;
        I_Time max = ((JMo_Time)pars[1]).time;
        if (this.time.isGreater(max)) {
            return (JMo_Time)pars[1];
        }
        if (min.isGreater(this.time)) {
            return (JMo_Time)pars[0];
        }
        return this;
    }

    @Override
    protected Str toStr(CallRuntime cr) {
        cr.pars(Str.class);
        return new Str(this.time.toString());
    }

    private I_Time getInternalValue() {
        return this.time;
    }

    @Override
    protected I_Date getInternalDate() {
        return null;
    }

    @Override
    protected I_Time getInternalTime() {
        return this.time;
    }

    @Override
    protected I_Object addsub(CallRuntime cr, boolean add) {
        return add ? this.add(cr, false) : this.sub(cr, false);
    }
}

