/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.form.FormText;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Short
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final short value;

    public JMo_Short(short val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public Integer compareTo2(I_AtomicValue o) {
        if (o instanceof JMo_Short) {
            return new Short(this.value).compareTo(((JMo_Short)o).getValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.SHORT, to, this, this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JMo_Short && ((JMo_Short)obj).getValue() == this.value;
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.parsExt(Bool.class, this, new Class[][]{{Bool.class, Char.class, JMo_Short.class, Dec.class}})[0];
        int par = Lib_Convert.getIntValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value > par);
            }
            case L: {
                return Bool.getObject(this.value < par);
            }
            case GE: {
                return Bool.getObject(this.value >= par);
            }
            case LE: {
                return Bool.getObject(this.value <= par);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new Int(~this.value);
            }
            case ABS: {
                return new Int(Math.abs(this.value));
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case INC: {
                    return new JMo_Short((short)(this.value + 1));
                }
                case DEC: {
                    return new JMo_Short((short)(this.value - 1));
                }
                case POW: {
                    return new Int(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
                case SHL: {
                    return new Int(this.value << 1);
                }
                case SHR: {
                    return new Int(this.value >> 1);
                }
            }
            throw Err.invalid(new Object[]{cr, op, pars});
        }
        A_Number par = (A_Number)cr.parType(pars[0], A_Number.class);
        if (op == A_Number.NOP01.POW && par instanceof JMo_Short) {
            short pari = ((JMo_Short)par).getValue();
            return new Int((int)Math.round(Math.pow(this.value, pari)));
        }
        double pard = Lib_Convert.getDoubleValue(cr, par);
        int pari = Lib_Convert.getIntValue(cr, par);
        switch (op) {
            case INC: {
                return new JMo_Short((short)(this.value + pari));
            }
            case DEC: {
                return new JMo_Short((short)(this.value - pari));
            }
            case POW: {
                return new Dec(Math.pow(this.value, pard));
            }
            case SQR: {
                return new Dec(Math.exp(Math.log(this.value) / pard));
            }
            case SHL: {
                return new Int(this.value << pari);
            }
            case SHR: {
                return new Int(this.value >> pari);
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pard);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number paro) {
        short val = this.value;
        if (paro instanceof JMo_Short) {
            int par = Lib_Convert.getIntValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Int(this.value + par);
                }
                case SUB: {
                    return new Int(this.value - par);
                }
                case MUL: {
                    return new Int(this.value * par);
                }
                case DIV: {
                    if (par == 0) {
                        throw new ExecError(cr, "Division by zero", this.value + "/" + par);
                    }
                    return new Dec((double)this.value / (double)par);
                }
                case MOD: {
                    return new Int(this.value % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
                case LOGR: {
                    return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
                }
                case AND: {
                    return new Int(this.value & par);
                }
                case OR: {
                    return new Int(this.value | par);
                }
                case XOR: {
                    return new Int(this.value ^ par);
                }
            }
        } else {
            double par = Lib_Convert.getDoubleValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Dec((double)val + par);
                }
                case SUB: {
                    return new Dec((double)val - par);
                }
                case MUL: {
                    return new Dec((double)val * par);
                }
                case DIV: {
                    if (par == 0.0) {
                        throw new ExecError(cr, "Division by zero", val + "/" + par);
                    }
                    return new Dec((double)val / par);
                }
                case MOD: {
                    return new Dec((double)val % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
                case LOGR: {
                    return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
                }
                case AND: {
                    return new Dec(Double.longBitsToDouble((long)this.value & Double.doubleToRawLongBits(par)));
                }
                case OR: {
                    return new Dec(Double.longBitsToDouble((long)this.value | Double.doubleToRawLongBits(par)));
                }
                case XOR: {
                    return new Dec(Double.longBitsToDouble((long)this.value ^ Double.doubleToRawLongBits(par)));
                }
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + paro.getClass().getSimpleName());
    }

    @Override
    protected I_AtomicValue number_opStr(CallRuntime cr, A_Number.NOP1 op, A_Atomic p) {
        short val = this.value;
        if (op == A_Number.NOP1.ADD) {
            if (p instanceof Str) {
                return new Str(String.valueOf(val) + ((Str)p).getValue());
            }
            if (p instanceof Char) {
                return new Char((char)(val + ((Char)p).getValue().charValue()));
            }
        }
        if (op == A_Number.NOP1.MUL) {
            if (p instanceof Str) {
                String s = FormText.sequence(((Str)p).getValue(), (long)this.value);
                return new Str(s);
            }
            if (p instanceof Char) {
                String s = FormText.sequence(((Char)p).getValue().charValue(), (long)this.value);
                return new Str(s);
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + p.getClass().getSimpleName());
    }
}

