/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_DecNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class Dec
extends A_DecNumber
implements I_Decimal,
I_Atomic {
    private final double value;

    public Dec(double val) {
        this.value = Lib_Math.normalize(val, 10);
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public Integer compareTo2(I_AtomicValue o) {
        if (o instanceof Dec) {
            return new Double(this.value).compareTo(((Dec)o).getValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.DEC, to, this, this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Dec && ((Dec)obj).getValue() == this.value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.parsExt(Bool.class, this, new Class[][]{{Bool.class, Char.class, Int.class, Dec.class}})[0];
        Double par = Lib_Convert.getDoubleValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value > par);
            }
            case L: {
                return Bool.getObject(this.value < par);
            }
            case GE: {
                return Bool.getObject(this.value >= par);
            }
            case LE: {
                return Bool.getObject(this.value <= par);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new Dec(-this.value);
            }
            case ABS: {
                return new Dec(Math.abs(this.value));
            }
        }
        throw new CodeError(cr, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case INC: {
                    return new Dec(this.value + 1.0);
                }
                case DEC: {
                    return new Dec(this.value - 1.0);
                }
                case POW: {
                    return new Dec(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
                case SHL: {
                    return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) << (int)Double.doubleToRawLongBits(1.0)));
                }
                case SHR: {
                    return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) >> (int)Double.doubleToRawLongBits(1.0)));
                }
            }
        } else {
            A_Number parn = (A_Number)cr.parType(pars[0], A_Number.class);
            double par = Lib_Convert.getDoubleValue(cr, parn);
            switch (op) {
                case INC: {
                    return new Dec(this.value + par);
                }
                case DEC: {
                    return new Dec(this.value - par);
                }
                case POW: {
                    return new Dec(Math.pow(this.value, par));
                }
                case SQR: {
                    return new Dec(Math.exp(Math.log(this.value) / par));
                }
                case SHL: {
                    return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) << (int)Double.doubleToRawLongBits(par)));
                }
                case SHR: {
                    return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) >> (int)Double.doubleToRawLongBits(par)));
                }
            }
        }
        throw new CodeError(cr, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pars.length);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number parn) {
        double val = this.value;
        double par = Lib_Convert.getDoubleValue(cr, parn);
        switch (op) {
            case ADD: {
                return new Dec(val + par);
            }
            case SUB: {
                return new Dec(val - par);
            }
            case MUL: {
                return new Dec(val * par);
            }
            case DIV: {
                if (par == 0.0) {
                    throw new ExecError(cr, "Division by zero", val + "/" + par);
                }
                return new Dec(val / par);
            }
            case MOD: {
                return new Dec(val % par);
            }
            case AND: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) & Double.doubleToRawLongBits(par)));
            }
            case OR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) | Double.doubleToRawLongBits(par)));
            }
            case XOR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) ^ Double.doubleToRawLongBits(par)));
            }
            case LOG: {
                return new Dec(Math.log(this.value) / Math.log(par));
            }
            case LOGR: {
                return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
            }
        }
        throw new CodeError(cr, "Unknown Type or Function", (Object)((Object)op) + " " + parn.getClass().getSimpleName());
    }

    @Override
    protected Str number_opStr(CallRuntime cr, A_Number.NOP1 op, A_Atomic p) {
        String val = "" + this.value;
        String par = Lib_Convert.getStringValue(cr, p);
        switch (op) {
            case ADD: {
                return new Str(String.valueOf(val) + par);
            }
            case MUL: {
                throw new CodeError(cr, "Wrong Type to multiply a Char or String", "Got " + this.getClass().getSimpleName() + ", please use Int");
            }
        }
        throw new CodeError(cr, "Unknown Type or Function", (Object)((Object)op) + " " + p.getClass().getSimpleName());
    }
}

