/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Exec;

public abstract class A_IntNumber
extends A_Number
implements I_AutoBlockDo {
    @Override
    protected final ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "rangeTo": {
                return A_Object.stdResult(this.range(cr));
            }
            case "toHex": {
                return A_Object.stdResult(this.toHex(cr));
            }
            case "chr": {
                return A_Object.stdResult(this.chr(cr));
            }
            case "timesUp": 
            case "times": {
                return this.times(cr, false);
            }
            case "timesDown": {
                return this.times(cr, true);
            }
            case "isEven": {
                return A_Object.stdResult(this.isEven(cr));
            }
            case "isOdd": {
                return A_Object.stdResult(this.isOdd(cr));
            }
            case "isBetween": {
                return A_Object.stdResult(this.isBetween(cr));
            }
            case "divisible": {
                return A_Object.stdResult(this.divisible(cr));
            }
            case "checksum": {
                return A_Object.stdResult(this.checksum(cr));
            }
        }
        return this.call5(cr, method);
    }

    protected abstract ObjectCallResult call5(CallRuntime var1, String var2);

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.times((CallRuntime)cr, (boolean)false).obj;
    }

    protected ObjectCallResult times(CallRuntime crOld, boolean reverse) {
        I_Object[] pars = crOld.parsBlockFlex(this, 0, 1);
        if (pars.length == 0 && crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "Wrong call", "No Parameter, no Stream, no Block, for times ... what to do?");
        }
        int value = ((Number)this.getValue()).intValue();
        int start = reverse ? value : 1;
        int end = reverse ? 0 : value + 1;
        int step = reverse ? -1 : 1;
        CallRuntime crNew = crOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        int i = start;
        while (i != end) {
            result = Lib_Exec.execBlock(crNew, args, new Int(i));
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            i += step;
        }
        return new ObjectCallResult(result, true);
    }

    private I_Object toHex(CallRuntime cr) {
        cr.pars(Str.class);
        long value = ((Number)this.getValue()).longValue();
        String s = Long.toHexString(value);
        return new Str(s);
    }

    private Bool isEven(CallRuntime cr) {
        cr.pars(Bool.class);
        long value = ((Number)this.getValue()).longValue();
        return Bool.getObject(value % 2L == 0L);
    }

    private Bool isOdd(CallRuntime cr) {
        cr.pars(Bool.class);
        long value = ((Number)this.getValue()).longValue();
        return Bool.getObject(value % 2L != 0L);
    }

    private Bool isBetween(CallRuntime cr) {
        I_Object[] oa = cr.pars(Bool.class, this, A_IntNumber.class, A_IntNumber.class);
        long value = ((Number)this.getValue()).longValue();
        long i1 = ((Number)((A_IntNumber)oa[0]).getValue()).longValue();
        long i2 = ((Number)((A_IntNumber)oa[1]).getValue()).longValue();
        return Bool.getObject(value >= i1 && value <= i2);
    }

    private JMo_Range range(CallRuntime cr) {
        I_Object dest = cr.pars(JMo_Range.class, this, A_Number.class)[0];
        return JMo_Range.createNew(cr, this, dest);
    }

    private JMo_List divisible(CallRuntime cr) {
        cr.pars(JMo_List.class, this, new Class[0]);
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        boolean isLong = this.getValue() instanceof Long;
        if (isLong) {
            long value = ((Number)this.getValue()).longValue();
            long i = Math.abs(value);
            int fi = 1;
            while ((long)fi <= i / 2L) {
                if ((double)i / (double)fi == (double)(i / (long)fi)) {
                    list.add(new JMo_Long(fi));
                }
                ++fi;
            }
            if (i != 0L) {
                list.add(new JMo_Long(i));
            }
            return new JMo_List(list);
        }
        int iv = ((Number)this.getValue()).intValue();
        int i = Math.abs(iv);
        int fi = 1;
        while (fi <= i / 2) {
            if ((double)i / (double)fi == (double)(i / fi)) {
                list.add(new Int(fi));
            }
            ++fi;
        }
        if (i != 0) {
            list.add(new Int(i));
        }
        return new JMo_List(list);
    }

    private Int checksum(CallRuntime cr) {
        cr.pars(Int.class);
        long l = ((Number)this.getValue()).longValue();
        return new Int(Lib_Math.checksum(l));
    }

    private Char chr(CallRuntime cr) {
        cr.pars(Char.class);
        char chr = (char)((Number)this.getValue()).intValue();
        return new Char(chr);
    }
}

