/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;

public abstract class A_DecNumber
extends A_Number {
    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "rangeTo": {
                return A_Object.stdResult(this.range(cr));
            }
            case "roundDown": 
            case "floor": {
                return A_Object.stdResult(this.floor(cr));
            }
            case "roof": 
            case "roundUp": {
                return A_Object.stdResult(this.roof(cr));
            }
            case "\u2248": 
            case "round": {
                return A_Object.stdResult(this.round(cr));
            }
            case "cos": {
                cr.pars(Dec.class);
                return A_Object.stdResult(new Dec(Math.cos(((Number)this.getValue()).doubleValue())));
            }
            case "sin": {
                cr.pars(Dec.class);
                return A_Object.stdResult(new Dec(Math.sin(((Number)this.getValue()).doubleValue())));
            }
            case "tan": {
                cr.pars(Dec.class);
                return A_Object.stdResult(new Dec(Math.tan(((Number)this.getValue()).doubleValue())));
            }
            case "acos": {
                cr.pars(Dec.class);
                return A_Object.stdResult(new Dec(Math.acos(((Number)this.getValue()).doubleValue())));
            }
            case "asin": {
                cr.pars(Dec.class);
                return A_Object.stdResult(new Dec(Math.asin(((Number)this.getValue()).doubleValue())));
            }
            case "atan": {
                cr.pars(Dec.class);
                return A_Object.stdResult(new Dec(Math.atan(((Number)this.getValue()).doubleValue())));
            }
        }
        return this.call5(cr, method);
    }

    protected abstract ObjectCallResult call5(CallRuntime var1, String var2);

    private Int floor(CallRuntime cr) {
        cr.pars(Int.class);
        double value = ((Number)this.getValue()).doubleValue();
        return new Int((int)Math.floor(value));
    }

    private JMo_Range range(CallRuntime cr) {
        I_Object to = cr.pars(JMo_Range.class, this, A_Number.class)[0];
        return JMo_Range.createNew(cr, this, to);
    }

    private Int roof(CallRuntime cr) {
        cr.pars(Int.class);
        double value = ((Number)this.getValue()).doubleValue();
        return new Int((int)Math.ceil(value));
    }

    private I_AtomicValue round(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(A_Number.class, this, 0, 1);
        double value = ((Number)this.getValue()).doubleValue();
        switch (pars.length) {
            case 0: {
                return new Int((int)Math.round(value));
            }
            case 1: {
                int i = Lib_Convert.getIntValue(cr, pars[0]);
                if (i < 0 || i > 10) {
                    throw new CodeError(cr, "Wrong parameter", "Got " + i + ", allowed = 0-10");
                }
                return new Dec(Lib_Math.round(value, i));
            }
        }
        throw Err.impossible(new Object[0]);
    }
}

