/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.constant.position.H_POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;

public class JMo_Table
extends A_Object
implements I_AutoBlockDo,
I_AutoBlockList {
    private I_Table<I_Object> tab;
    private ParCallBuffer width;

    public JMo_Table(Call width) {
        this.width = new ParCallBuffer(width);
    }

    public JMo_Table(I_Table<I_Object> init_tab) {
        this.tab = init_tab;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.width != null) {
            this.width.init(cr, this, A_IntNumber.class);
            if (this.tab == null) {
                int w = Lib_Convert.getIntValue(cr, this.width.get());
                this.tab = new MTable<I_Object>(w);
            }
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "getItem": {
                return A_Object.stdResult(this.getItem(cr));
            }
            case "getRow": 
            case "get": {
                return A_Object.stdResult(this.get(cr));
            }
            case "set": {
                return A_Object.stdResult(this.set(cr));
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "search": {
                return A_Object.stdResult(this.search(cr));
            }
            case "searchFirst": {
                return A_Object.stdResult(this.searchFirst(cr));
            }
            case "width": {
                cr.pars(Int.class);
                return A_Object.stdResult(new Int(this.tab.getWidth()));
            }
            case "length": 
            case "len": 
            case "size": {
                cr.pars(Int.class);
                return A_Object.stdResult(new Int(this.tab.size()));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Sequence i_Sequence : this.tab) {
            ArrayList<I_Object> row = new ArrayList<I_Object>();
            for (I_Object si : i_Sequence) {
                row.add(si);
            }
            result.add(new JMo_List(row));
        }
        return result;
    }

    public I_Table<I_Object> getInternalObject() {
        return this.tab;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toText(cr, true);
    }

    @Override
    public String toString() {
        return this.toText(null, false);
    }

    private String toText(CallRuntime cr, boolean debug) {
        if (this.tab == null) {
            return "Table";
        }
        boolean[][] right = new boolean[this.tab.getWidth()][this.tab.size()];
        MTable<String> otab = new MTable<String>(this.tab.getWidth());
        int y = 0;
        for (I_Sequence i_Sequence : this.tab) {
            String[] sa = new String[i_Sequence.size()];
            int x = 0;
            while (x < sa.length) {
                I_Object o = (I_Object)i_Sequence.get(x + 1);
                Class<?> t = o.getClass();
                right[x][y] = t == Int.class || t == Dec.class;
                sa[x] = debug ? o.toDebug(cr) : o.toString();
                ++x;
            }
            otab.add(sa);
            ++y;
        }
        int[] nArray = new int[this.tab.getWidth()];
        int spalte = 1;
        while (spalte <= this.tab.getWidth()) {
            int max = 0;
            int zeile = 1;
            while (zeile <= this.tab.size()) {
                max = Math.max(max, ((String)otab.get(spalte, zeile)).length());
                ++zeile;
            }
            nArray[spalte - 1] = max;
            ++spalte;
        }
        StringBuilder sb = new StringBuilder();
        y = 0;
        for (I_Sequence zeile : otab) {
            int spalte2 = 1;
            while (spalte2 <= this.tab.getWidth()) {
                String o = (String)zeile.get(spalte2);
                H_POSITION.H pos = right[spalte2 - 1][y] ? POSITION_H.RIGHT : POSITION_H.LEFT;
                sb.append(FormText.width(nArray[spalte2 - 1], ' ', o, pos, false));
                if (spalte2 != this.tab.getWidth()) {
                    sb.append('|');
                }
                ++spalte2;
            }
            if (++y >= this.tab.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private JMo_Table add(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(JMo_Table.class, this, this.tab.getWidth(), this.tab.getWidth());
        this.tab.add((I_Object[])pars);
        return this;
    }

    private ObjectCallResult each(CallRuntime crOld) {
        I_Object[] pars = crOld.parsBlockFlex(this, 0, 1);
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            Err.impossible("No block, no stream, what should I do?");
        }
        CallRuntime cpNew = crOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = Nil.NIL;
        for (I_Sequence i_Sequence : this.tab) {
            I_Object itO = this.rowToList(i_Sequence);
            result = Lib_Exec.execBlock(cpNew, args, itO);
            if (!((result = Lib_Exec.loopResult(result)) instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private I_Object getItem(CallRuntime cr) {
        I_Object[] pars = cr.pars(null, this, A_IntNumber.class, A_IntNumber.class);
        int x = Lib_Convert.getIntValue(cr, pars[0]);
        int y = Lib_Convert.getIntValue(cr, pars[1]);
        return this.tab.get(x, y);
    }

    private I_Object get(CallRuntime cr) {
        I_Object y = cr.pars(null, this, A_IntNumber.class)[0];
        int iy = Lib_Convert.getIntValue(cr, y);
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), iy);
        return this.rowToList((I_Sequence)this.tab.get(iy));
    }

    private I_Object rowToList(I_Sequence<I_Object> it) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (I_Object item : it) {
            al.add(item);
        }
        return new JMo_List(al);
    }

    private JMo_Table search(CallRuntime cr) {
        I_AtomicValue searcho = (I_AtomicValue)cr.pars(JMo_Table.class, this, I_AtomicValue.class)[0];
        String search = Lib_Convert.getStringValue(cr, searcho);
        MTable<I_Object> res = new MTable<I_Object>(this.tab.getWidth());
        int y = 1;
        while (y <= this.tab.size()) {
            boolean add = false;
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                if (s.equals(search)) {
                    add = true;
                    break;
                }
                ++x;
            }
            if (add) {
                I_Sequence row = (I_Sequence)this.tab.get(y);
                res.add(row);
            }
            ++y;
        }
        return new JMo_Table(res);
    }

    private I_Object searchFirst(CallRuntime cr) {
        I_AtomicValue searcho = (I_AtomicValue)cr.pars(JMo_List.class, this, I_AtomicValue.class)[0];
        String search = Lib_Convert.getStringValue(cr, searcho);
        int y = 1;
        while (y <= this.tab.size()) {
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                if (s.equals(search)) {
                    I_Sequence row = (I_Sequence)this.tab.get(y);
                    ArrayList<I_Object> row2 = new ArrayList<I_Object>();
                    for (I_Object item : row) {
                        row2.add(item);
                    }
                    return new JMo_List(row2);
                }
                ++x;
            }
            ++y;
        }
        return Nil.NIL;
    }

    private JMo_Table set(CallRuntime cr) {
        I_Object[] xyo = cr.pars(JMo_Table.class, this, A_IntNumber.class, A_IntNumber.class, I_Object.class);
        int x = Lib_Convert.getIntValue(cr, xyo[0]);
        int y = Lib_Convert.getIntValue(cr, xyo[1]);
        this.tab.set(x, y, xyo[2]);
        return this;
    }
}

