/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys;

import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_Error;
import de.mn77.base.sys.Log;
import de.mn77.base.thread.ThreadQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class MOut {
    private static final int TRACELINES_SMALL = 5;
    private static final int TRACELINES_MEDIUM = 15;
    private static DEBUG_LEVEL debuginfo = DEBUG_LEVEL.NO;
    private static boolean log = false;
    private static final ThreadQueue queue = new ThreadQueue();
    private static String linebreak = System.lineSeparator();
    private static boolean java_errors = true;

    public static DEBUG_LEVEL getDebugInfo() {
        return debuginfo;
    }

    public static void setDebug(DEBUG_LEVEL di) {
        debuginfo = di;
    }

    public static void debugNo() {
        debuginfo = DEBUG_LEVEL.NO;
    }

    public static void debugMin() {
        debuginfo = DEBUG_LEVEL.MINIMAL;
    }

    public static void debugDetail() {
        debuginfo = DEBUG_LEVEL.DETAIL;
    }

    public static void debugParanoid() {
        debuginfo = DEBUG_LEVEL.PARANOID;
    }

    public static void setLineBreak(String s) {
        linebreak = s;
    }

    public static void setJavaErrors(boolean b) {
        java_errors = b;
    }

    public static void useLog() {
        if (!Log.getActive()) {
            Err.forbidden("Log not activated!");
        } else {
            log = true;
        }
    }

    public static void error(String text) {
        MOut.error(new RuntimeException(), text);
    }

    public static void error(Throwable t) {
        MOut.error(t, null);
    }

    public static void error(Throwable t, String text) {
        MOut.error(t, text, false);
    }

    private static void error(Throwable t, String text, boolean isCause) {
        if (t == null) {
            t = new RuntimeException();
        }
        StackTraceElement[] sta = t.getStackTrace();
        ArrayList<Object> list = new ArrayList<Object>();
        if (text != null) {
            list.add(text);
        }
        String className = java_errors && debuginfo.ordinal() > DEBUG_LEVEL.MINIMAL.ordinal() ? t.getClass().getName() : t.getClass().getSimpleName();
        list.add(String.valueOf(className) + ": " + t.getMessage());
        if (t instanceof I_Error) {
            I_Error bf = (I_Error)((Object)t);
            for (Object o : bf.getDetails()) {
                list.add(o);
            }
        }
        MOut.iWrite(true, true, isCause, TAG.ERROR, sta, list.toArray());
        if (t.getCause() != null) {
            MOut.error(t.getCause(), null, true);
        }
    }

    public static void warnung(Object ... oa) {
        if (debuginfo == DEBUG_LEVEL.NO) {
            return;
        }
        StackTraceElement[] trace = new Throwable().getStackTrace();
        MOut.iWrite(true, true, false, TAG.WARN, trace, oa);
    }

    public static void echo(Object o) {
        String s = ConvObject.toTextOutput(o);
        if (debuginfo == DEBUG_LEVEL.NO) {
            MOut.iWrite(false, false, false, TAG.TEXT, null, s);
        } else {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            MOut.iWrite(false, false, false, TAG.TEXT, trace, s);
        }
    }

    public static void text(Object ... oa) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < oa.length) {
            if (i > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(ConvObject.toTextOutput(oa[i]));
            ++i;
        }
        if (debuginfo == DEBUG_LEVEL.NO) {
            MOut.iWrite(false, true, false, TAG.TEXT, null, sb.toString());
        } else {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            MOut.iWrite(false, true, false, TAG.TEXT, trace, sb.toString());
        }
    }

    public static void debug(Object ... oa) {
        if (debuginfo == DEBUG_LEVEL.NO) {
            return;
        }
        StackTraceElement[] trace = new Throwable().getStackTrace();
        MOut.iWrite(false, true, false, TAG.DEBUG, trace, oa);
    }

    public static void debugVersetzt(int offset, Object ... oa) {
        if (debuginfo == DEBUG_LEVEL.NO) {
            return;
        }
        StackTraceElement[] trace = new Throwable().getStackTrace();
        Err.ifOutOfBounds(0.0, Math.min(trace.length - 2, 3), offset);
        int destLen = trace.length - offset;
        StackTraceElement[] trace2 = new StackTraceElement[destLen];
        System.arraycopy(trace, offset, trace2, 0, destLen);
        MOut.iWrite(false, true, false, TAG.DEBUG, trace, oa);
    }

    public static void dev(Object ... oa) {
        if (debuginfo == DEBUG_LEVEL.NO || debuginfo == DEBUG_LEVEL.MINIMAL) {
            return;
        }
        StackTraceElement[] sta = new Throwable().getStackTrace();
        MOut.iWrite(false, true, false, TAG.DEV, sta, oa);
    }

    public static void exit(Object ... oa) {
        StackTraceElement[] sta = new Throwable().getStackTrace();
        debuginfo = DEBUG_LEVEL.NO;
        MOut.iWrite(false, true, false, TAG.DEV, sta, oa);
        debuginfo = DEBUG_LEVEL.PARANOID;
        MOut.iWrite(false, true, true, TAG.DEV, sta, "Stop for debugging!");
        System.exit(1);
    }

    public static void temp(Object ... oa) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("--- Temp-Debug-Info --- " + linebreak);
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(String.valueOf(ConvObject.toTextDebug(o)) + linebreak);
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        MOut.iWrite(true, true, false, TAG.DEBUG, trace, sb.toString());
    }

    public static void trace(Object ... oa) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("--- Trace-Debug-Info --- " + linebreak);
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(String.valueOf(ConvObject.toTextDebug(o)) + linebreak);
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        DEBUG_LEVEL debug_mem = debuginfo;
        debuginfo = DEBUG_LEVEL.PARANOID;
        MOut.iWrite(true, true, false, TAG.DEV, trace, sb.toString());
        debuginfo = debug_mem;
    }

    public static void line(Object ... oa) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("--- Line-Debug-Info --- " + linebreak);
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(String.valueOf(ConvObject.toTextDebug(o)) + linebreak);
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(trace[1]);
        MOut.iWrite(false, true, false, TAG.DEBUG, trace, sb.toString());
    }

    public static OutputStream streamText() {
        return MOut.iStream(false, TAG.TEXT);
    }

    public static OutputStream streamError() {
        return MOut.iStream(true, TAG.ERROR);
    }

    private static PrintStream iStream(final boolean error, final TAG tag) {
        return new PrintStream(new OutputStream(){
            private final StringBuilder sb = new StringBuilder();

            @Override
            public void write(int i) throws IOException {
                this.sb.append(new String(new byte[]{(byte)i}));
            }

            @Override
            public void close() throws IOException {
                super.close();
                MOut.iWrite(error, true, false, tag, null, new Object[]{this.sb.toString()});
            }
        });
    }

    private static synchronized void iWrite(boolean error, boolean newline, boolean addOn, TAG tag, StackTraceElement[] trace, Object ... oa) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!addOn && (error || tag != TAG.TEXT && debuginfo.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal())) {
            lines.add(new MDateTime().toStringIT());
        }
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lines.add(error || debuginfo.ordinal() <= DEBUG_LEVEL.MINIMAL.ordinal() ? ConvObject.toTextOutput(o) : ConvObject.toTextDebug(o));
            ++n2;
        }
        if (java_errors && trace != null) {
            String indent = "   ";
            if (error || debuginfo == DEBUG_LEVEL.PARANOID || tag != TAG.TEXT && debuginfo == DEBUG_LEVEL.DETAIL) {
                int noch = trace.length;
                int got = 0;
                StackTraceElement[] stackTraceElementArray = trace;
                int n3 = trace.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement st = stackTraceElementArray[n4];
                    String stt = st.toString();
                    if (!(stt.matches("^(sun|java)\\..*$") || stt.matches("^.*:1\\)$") || stt.contains(MOut.class.getName()) || stt.contains(Err.class.getName()) || debuginfo.ordinal() <= DEBUG_LEVEL.MINIMAL.ordinal() && (stt.indexOf("Err") >= 0 || stt.matches("^de.mn77.base.error.*$")))) {
                        boolean last;
                        boolean bl = last = --noch == 0;
                        if (last || debuginfo == DEBUG_LEVEL.PARANOID || debuginfo == DEBUG_LEVEL.DETAIL || tag != TAG.ERROR && got < 5 || tag == TAG.ERROR && got < (debuginfo == DEBUG_LEVEL.NO ? 5 : 15)) {
                            lines.add("   " + (last ? ">" : "@") + " " + stt);
                        }
                        ++got;
                    }
                    ++n4;
                }
            } else if (tag != TAG.TEXT && debuginfo == DEBUG_LEVEL.MINIMAL || tag == TAG.TEXT && debuginfo == DEBUG_LEVEL.DETAIL) {
                lines.add("   @ " + trace[1].toString());
            }
        }
        boolean doppelt = false;
        try {
            doppelt = queue.entrance();
        }
        catch (Exception e) {
            Err.show(e);
        }
        try {
            if (doppelt) {
                String s = String.join((CharSequence)linebreak, lines);
                MOut.output(error, newline, s);
            } else {
                String trenner = "";
                if (java_errors) {
                    if (debuginfo.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal()) {
                        trenner = String.valueOf(trenner) + new MTime().toString() + " ";
                    }
                    if (java_errors && debuginfo.ordinal() >= DEBUG_LEVEL.MINIMAL.ordinal()) {
                        trenner = String.valueOf(trenner) + FormText.width(6, ' ', tag.name(), POSITION_H.LEFT, false) + "| ";
                    }
                }
                String s = String.valueOf(trenner) + String.join((CharSequence)(String.valueOf(linebreak) + trenner), lines);
                if (!addOn && (error || debuginfo.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal())) {
                    s = String.valueOf(linebreak) + s;
                }
                MOut.output(error, newline, s);
            }
        }
        finally {
            queue.leave();
        }
    }

    private static void output(boolean error, boolean newline, String s) {
        if (error) {
            if (newline) {
                System.err.println(s);
            } else {
                System.err.print(s);
            }
        } else if (newline) {
            System.out.println(s);
        } else {
            System.out.print(s);
        }
        if (log) {
            Log.write(s);
        }
    }

    private static enum TAG {
        TEXT,
        DEBUG,
        WARN,
        ERROR,
        DEV;

    }
}

