/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormText;
import de.mn77.base.error.Err;

public class FormNumber {
    public static String width(int width, long number, boolean cutOverflow) {
        return FormNumber.width(width, "" + number, cutOverflow);
    }

    public static String width(int width, String number, boolean cutOverflow) {
        String s;
        boolean negative = number.charAt(0) == '-';
        String string = s = negative ? number.substring(1) : number;
        if (negative) {
            --width;
        }
        if (width <= s.length()) {
            if (!cutOverflow) {
                return number;
            }
            throw Err.todo(width, number, cutOverflow);
        }
        return String.valueOf(negative ? "-" : "") + FormText.width(width, '0', s, POSITION_H.RIGHT, false);
    }

    public static String right(int fieldwidth, long number) {
        return FormText.width(fieldwidth, ' ', "" + number, POSITION_H.RIGHT, false);
    }

    public static String round(double d, int digits) {
        Err.ifOutOfBounds(0.0, 16.0, digits);
        double multi = digits == 0 ? 1.0 : Lib_Math.power(10.0, digits);
        double rounded = (double)Math.round(d * multi) / multi;
        String result = "" + rounded;
        int idx = result.indexOf(46);
        int len = result.length();
        int dec = len - idx - 1;
        while (dec < digits) {
            result = String.valueOf(result) + "0";
            ++dec;
        }
        return result;
    }
}

