/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.form.FormText;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.tools.Lib_StringParser;

public class Lib_Parser {
    public static final String COMBINE_CHARS = "\\+\\*/.\\],";

    public static int getDepth(String s) {
        int count = 0;
        int pos = 0;
        while (pos < s.length()) {
            if (s.charAt(pos) == '\t') {
                ++count;
            } else {
                return count;
            }
            ++pos;
        }
        return count;
    }

    public static I_List<FunctionPar> getFunctionPars(App app, Block current, String s, DebugInfo debug) {
        String ps = s.replaceFirst("^.*\\((.*)\\).*$", "$1");
        String[] psa = ps.split(",");
        MList<FunctionPar> pars = new MList<FunctionPar>();
        String[] stringArray = psa;
        int n = psa.length;
        int n2 = 0;
        while (n2 < n) {
            String pName;
            String element = stringArray[n2];
            String sa = element.trim();
            String regexPar = "^(([A-Z][A-Za-z0-9_]*)\\s+)?([a-zA-Z][A-Za-z0-9_]*[?\u00bf]?)(\\s*=\\s*(.*))?$";
            String pType = sa.replaceFirst("^(([A-Z][A-Za-z0-9_]*)\\s+)?([a-zA-Z][A-Za-z0-9_]*[?\u00bf]?)(\\s*=\\s*(.*))?$", "$2");
            if (pType.length() == 0) {
                pType = null;
            }
            if ((pName = sa.replaceFirst("^(([A-Z][A-Za-z0-9_]*)\\s+)?([a-zA-Z][A-Za-z0-9_]*[?\u00bf]?)(\\s*=\\s*(.*))?$", "$3")).length() == 0) {
                pName = null;
            }
            String pDef = sa.replaceFirst("^(([A-Z][A-Za-z0-9_]*)\\s+)?([a-zA-Z][A-Za-z0-9_]*[?\u00bf]?)(\\s*=\\s*(.*))?$", "$5");
            I_Object pDefC = null;
            if (pDef.length() > 0) {
                Group2<I_Object, String> g = Parser_Call.parseObject(app, current, pDef, debug);
                if (g.g2() != null && g.g2().length() > 0) {
                    Err.forbidden(g.g2());
                }
                pDefC = g.g1();
            }
            boolean fix = !pName.matches("[a-z][A-Za-z0-9_]*(\u00bf|\\?\\?|\\?)?");
            app.strict.checkFuncParType(pType, pName, debug);
            FunctionPar fpar = new FunctionPar(pType, fix, pName, pDefC);
            pars.add(fpar);
            ++n2;
        }
        return pars;
    }

    public static String[] getSentence(String s) {
        boolean open_string = false;
        boolean open_char = false;
        boolean open_cmd = false;
        boolean ignore = false;
        char[] ca = s.toCharArray();
        int pos = 0;
        while (pos < s.length()) {
            char c = ca[pos];
            if (ignore) {
                ignore = false;
            } else if (c == '\\') {
                ignore = true;
            } else if (c == '\'' && !open_string) {
                open_char = !open_char;
            } else if (c == '\"' && !open_char) {
                open_string = !open_string;
            } else if (!(c != '\u00b4' && c != '`' || open_char || open_string)) {
                open_cmd = !open_cmd;
            } else if (!(open_char || open_string || open_cmd)) {
                if (c == '#') {
                    String[] sa = new String[]{s.substring(0, pos), ""};
                    return sa;
                }
                if (c == ';') {
                    String[] sa = new String[]{s.substring(0, pos), s.substring(pos + 1)};
                    return sa;
                }
            }
            ++pos;
        }
        String[] stringArray = new String[2];
        stringArray[0] = s;
        return stringArray;
    }

    public static final String group(char open, char close, String s, DebugInfo debugInfo) {
        int deep = 0;
        int start = -1;
        int pos = 0;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (c == open) {
                ++deep;
                if (start == -1) {
                    start = pos;
                }
            }
            if (c == '\"') {
                pos += 1 + Lib_StringParser.checkString(s.substring(pos), true, debugInfo);
            } else if (c == '\'') {
                pos += Lib_StringParser.checkChar(s.substring(pos), true, debugInfo) - 1;
            } else if (c == close && --deep == 0) {
                return s.substring(start + 1, pos);
            }
            ++pos;
        }
        if (deep == 0) {
            return s;
        }
        throw new ParseError("Uncomplete group " + open + close, s, debugInfo);
    }

    public static final Group2<String, Integer> regexGet(String s, DebugInfo debugInfo) {
        char[] ca = s.toCharArray();
        int pos = 1;
        while (pos < ca.length) {
            char c = ca[pos];
            switch (c) {
                case '\\': {
                    ++pos;
                    break;
                }
                case '\"': {
                    return new Group2<String, Integer>(s.substring(1, pos), pos);
                }
            }
            ++pos;
        }
        return null;
    }

    public static char replaceEscapeChar(char c, DebugInfo debugInfo) {
        switch (c) {
            case '\\': {
                return c;
            }
            case '\'': {
                return c;
            }
            case '\"': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'b': {
                return '\b';
            }
        }
        throw new ParseError("Unknown char", "" + c, debugInfo);
    }

    public static char replaceUtfChar(String s, int pos, DebugInfo debugInfo) {
        String hex = s.substring(pos + 1, pos + 5);
        if (pos + 5 >= s.length()) {
            throw new ParseError("Uncomplete UTF-Character", "Got: " + hex, debugInfo);
        }
        int value = Integer.parseInt(hex, 16);
        char cv = (char)value;
        return cv;
    }

    public static String setDepth(int d, String s) {
        s = s.trim();
        return String.valueOf(FormText.sequence('\t', (long)d)) + s;
    }

    public static final String space(int level) {
        return FormText.sequence(' ', (long)(level * 2));
    }

    public static final Group2<String, Integer> stringGet(String s, DebugInfo debugInfo) {
        char[] ca = s.toCharArray();
        StringBuilder sb = new StringBuilder(ca.length);
        int pos = 1;
        while (pos < ca.length) {
            char c = ca[pos];
            switch (c) {
                case '\\': {
                    char temp = ca[++pos];
                    if (temp == 'u') {
                        char utf = Lib_Parser.replaceUtfChar(s, pos, debugInfo);
                        sb.append(utf);
                        pos += 4;
                        break;
                    }
                    sb.append(Lib_Parser.replaceEscapeChar(temp, debugInfo));
                    break;
                }
                case '\"': {
                    return new Group2<String, Integer>(sb.toString(), pos);
                }
                default: {
                    sb.append(c);
                }
            }
            ++pos;
        }
        return null;
    }

    public static String shortcutVarLet(String s) {
        if (s.length() > 0 && s.charAt(0) == ':') {
            String v = s.replaceFirst(":([a-z][A-Za-z0-9_]*(\u00bf|\\?\\?|\\?)?).*", "$1");
            String rem = s.substring(v.length() + 1);
            return "(:" + v + ')' + rem;
        }
        return s;
    }
}

