/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;

public class Lib_Par {
    public static void checkBlock(CurProc cp, Class<?> result) {
        if (result != null && Lib_Class.isHeir(result, I_AutoBlockDo.class)) {
            return;
        }
        Lib_Par.checkBlockForbidden(cp);
    }

    public static void checkBlockNecessary(CurProc cp) {
        if (cp.call.getCallBlock() == null) {
            throw new CodeError(cp, "Function-Call", "Block needed for this function");
        }
    }

    public static void checkBlockForbidden(CurProc cp) {
        if (cp.call.getCallBlock() != null) {
            throw new CodeError(cp, "Function-Call", "No Block allowed for this function");
        }
    }

    public static I_Object checkParAdvance(CurProc cp, I_Object streamIt, int parNr, Class<?> type) {
        I_Object par = cp.call.getParAdvance(cp, streamIt, parNr);
        return Lib_Par.checkPar(cp, par, type);
    }

    public static I_Object checkPar(CurProc cp, I_Object par, Class<?> type) {
        I_Object parReal = Lib_Convert.getValue(cp, par);
        if (type != null && !type.isAssignableFrom(parReal.getClass())) {
            throw new CodeError(cp, "Wrong type of parameter", "Got " + Lib_Convert.typeName(parReal.getClass(), par) + "(" + par.toDebug(cp) + "), expected: " + Lib_Par.typelistToText(type));
        }
        return parReal;
    }

    public static I_Object checkParExt(CurProc cp, I_Object par, Class<?>[] types) {
        I_Object parReal = Lib_Convert.getValue(cp, par);
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(parReal.getClass())) {
                return parReal;
            }
            ++n2;
        }
        throw new CodeError(cp, "Wrong type of parameter", "Got " + par.getTypeName() + "(" + par.toDebug(cp) + "), expected: " + Lib_Par.typelistToText(new Class[][]{types}));
    }

    public static I_Object[] checkPars(CurProc cp, I_Object streamIt, I_Object[] eachIt, Class<?> ... types) {
        Err.ifNull(cp.call);
        I_Object[] pars = cp.call.getPars(cp, streamIt, eachIt);
        int oal = pars.length;
        if (oal != types.length) {
            throw new CodeError(cp, "Wrong count of parameters", "Got " + oal + ", want " + types.length);
        }
        int i = 0;
        while (i < oal) {
            pars[i] = Lib_Par.checkPar(cp, pars[i], types[i]);
            ++i;
        }
        return pars;
    }

    public static I_Object[] checkParsExt(CurProc cp, I_Object streamIt, Class<?>[] ... types) {
        I_Object[] pars = cp.call.getPars(cp, streamIt, null);
        if (pars.length != types.length) {
            throw new CodeError(cp, "Wrong count of parameters", "Got " + types.length + ", want " + types.length);
        }
        int i = 0;
        while (i < pars.length) {
            pars[i] = Lib_Convert.getValue(cp, pars[i]);
            if (types[i] != null) {
                boolean hit = false;
                Class<?>[] classArray = types[i];
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> t = classArray[n2];
                    if (t.isAssignableFrom(pars[i].getClass())) {
                        hit = true;
                        break;
                    }
                    ++n2;
                }
                if (!hit) {
                    throw new CodeError(cp, "Wrong type of parameter", "Got " + Lib_Par.objTypesToText(pars) + ", expected " + Lib_Par.typelistToText(types));
                }
            }
            ++i;
        }
        return pars;
    }

    public static I_Object[] checkParsFlex(CurProc cp, I_Object streamIt, I_Object[] eachIt, int par_min, int par_max) {
        I_Object[] pars = cp.call.getPars(cp, streamIt, eachIt);
        int len = pars.length;
        if (!Lib_Math.isBetween(len, par_min, par_max)) {
            String want = par_min == par_max ? "" + par_min : String.valueOf(par_min) + "-" + par_max;
            throw new CodeError(cp, "Wrong count of parameter", "Got " + len + ", want " + want);
        }
        int i = 0;
        while (i < len) {
            pars[i] = Lib_Convert.getValue(cp, pars[i]);
            ++i;
        }
        return pars;
    }

    private static String objTypesToText(I_Object[] oa) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int ioa = 0;
        while (ioa < oa.length) {
            I_Object o = oa[ioa];
            if (ioa != 0) {
                sb.append(", ");
            }
            sb.append(o.getTypeName());
            ++ioa;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String typelistToText(Class<?> type) {
        return Lib_Convert.typeName(type, null);
    }

    private static String typelistToText(Class<?>[][] types) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int ica = 0;
        while (ica < types.length) {
            Class<?>[] ca = types[ica];
            if (ica != 0) {
                sb.append(", ");
            }
            if (ca.length > 1) {
                sb.append('[');
            }
            int i = 0;
            while (i < ca.length) {
                if (i != 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_Convert.typeName(ca[i], null));
                ++i;
            }
            if (ca.length > 1) {
                sb.append(']');
            }
            ++ica;
        }
        sb.append(")");
        return sb.toString();
    }
}

