/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.error.Err;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.struct.runtime.VarConstEnv;
import org.jmo_lang.tools.Lib_Exec;

public class Instance
extends A_EventObject {
    private final Type type;
    private final App app;
    private final Call[] pars;
    private VarConstEnv main_env = null;

    public Instance(App app, Type type, Call[] pars) {
        this.type = type;
        this.app = app;
        this.pars = pars;
    }

    @Override
    public void init(CurProc cpOld) {
        CurProc cpNew = new CurProc(this, cpOld.call);
        this.main_env = cpNew.vce;
        I_Object[] parObjs = null;
        if (this.pars != null) {
            parObjs = new I_Object[this.pars.length];
            int i = 0;
            while (i < parObjs.length) {
                parObjs[i] = this.pars[i].exec(cpNew, null);
                ++i;
            }
        } else {
            parObjs = new I_Object[]{};
        }
        this.type.getBlock().execTypeBlock(cpOld, cpNew, parObjs);
    }

    @Override
    public Result_Obj callMethod(CurProc cpOld) {
        Function f = this.type.getFunctions().get(cpOld, cpOld.getMethod());
        CurProc cpNew = cpOld.copyVCE(this, this.main_env, true);
        try {
            return Instance.stdResult(f.gBlock().execFunction(cpNew, f));
        }
        catch (ReturnException r) {
            Lib_Exec.checkIsReturn(cpNew, r);
            return Instance.stdResult(r.get().getResult());
        }
    }

    @Override
    protected Result_Obj callEvent(CurProc cp) {
        return null;
    }

    @Override
    public int compareTo(I_Object o) {
        throw Err.todo(o);
    }

    public App gApp() {
        return this.app == null ? (App)this : this.app;
    }

    public Type getType() {
        return this.type;
    }

    public VarConstEnv getMainEnv() {
        return this.main_env;
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Instance(" + this.type.getName() + ")";
    }

    protected void setMainEnv(VarConstEnv vce) {
        if (this.main_env != null) {
            Err.forbidden("Is already set!");
        }
        this.main_env = vce;
    }
}

