/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.sys.MOut;
import java.util.HashMap;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.EventManager;
import org.jmo_lang.struct.FuncManager;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Parser;

public class Type {
    private final String name;
    private final Block mainblock;
    private final FuncManager functions;
    private final EventManager events;
    private final FunctionPar[] pars;
    private final HashMap<String, Type> selfTypes = new HashMap();

    public Type(String name, FunctionPar[] pars, DebugInfo debugInfo) {
        this.name = name;
        this.mainblock = new Block(this);
        this.functions = new FuncManager();
        this.events = new EventManager();
        this.pars = pars;
        if (this.pars != null) {
            FunctionPar[] functionParArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar par = functionParArray[n2];
                if (par.isConst) {
                    this.mainblock.gConstManager().create(par.name, debugInfo);
                } else {
                    this.mainblock.gVarManager().create(par.name, debugInfo);
                }
                ++n2;
            }
        }
    }

    public void addType(Type typ, DebugInfo debug) {
        String newname = typ.getName();
        for (String s : this.selfTypes.keySet()) {
            if (!newname.equals(s)) continue;
            throw new ParseError("Type-Name already used!", "You cannot redeclare: " + newname, debug);
        }
        this.selfTypes.put(newname, typ);
    }

    public void describe(CurProc cp, int depth) {
        String space = Lib_Parser.space(depth);
        MOut.text(String.valueOf(space) + this.toDebug());
        if (this.functions != null) {
            this.functions.describe(cp, depth + 1);
        }
        if (this.events != null) {
            this.events.describe(cp, depth + 1);
        }
        if (this.mainblock != null) {
            this.mainblock.describe(cp, depth + 1);
        }
        if (this.selfTypes != null) {
            for (Type t : this.selfTypes.values()) {
                t.describe(cp, depth + 1);
            }
        }
    }

    public Block getBlock() {
        return this.mainblock;
    }

    public Type getType(String type) {
        return this.selfTypes.getOrDefault(type, null);
    }

    public EventManager getEvents() {
        return this.events;
    }

    public FuncManager getFunctions() {
        return this.functions;
    }

    public String getName() {
        return this.name;
    }

    public FunctionPar[] getVars() {
        return this.pars;
    }

    public String toString() {
        return this.toDebug();
    }

    private String toDebug() {
        return ":" + this.name;
    }
}

