/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.MC_THIS;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ConstManager;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.VarManager;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;

public class Block
extends A_Object {
    private static int counter = 0;
    private final int nr;
    private ArrayList<Call> items = null;
    private final Block parent;
    private final Function func;
    private final Type typ;
    private final VarManager vars;
    private final ConstManager consts;
    private I_Object blockIT = null;

    public Block(Type typ) {
        this(typ, null, null);
    }

    public Block(Type typ, Function func, Block parent) {
        this.typ = typ;
        this.func = func;
        this.parent = parent;
        this.nr = ++counter;
        this.vars = new VarManager(parent == null ? null : parent.gVarManager());
        this.consts = new ConstManager(parent == null ? null : parent.gConstManager());
    }

    @Override
    public void init(CurProc cp) {
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "=": {
                this.blockIT = cp.pars(Block.class, this, new Class[]{null})[0];
                return Block.stdResult(this);
            }
        }
        return null;
    }

    public final void add(Call m) {
        Err.ifNull(m);
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(m);
    }

    @Override
    public int compareTo(I_Object o) {
        throw Err.todo(o);
    }

    @Override
    public void describe(CurProc cp, int left) {
        String space = Lib_Parser.space(left);
        String space2 = Lib_Parser.space(left + 1);
        MOut.text(String.valueOf(space) + this.toDebug(cp));
        if (this.vars != null && this.vars.count() > 0) {
            MOut.text(String.valueOf(space2) + "Variables:");
            this.vars.describe(cp, left + 2);
        }
        if (this.consts != null && this.consts.count() > 0) {
            MOut.text(String.valueOf(space2) + "Constants:");
            this.consts.describe(cp, left + 2);
        }
        if (this.items != null && this.items.size() > 0) {
            MOut.text(String.valueOf(space2) + "Items:");
            for (Call c : this.items) {
                c.describe(cp, left + 2);
            }
        }
    }

    public final I_Object execAppRoot(CurProc cp) throws ReturnException {
        return this.iExec(cp, this.blockIT)[1];
    }

    public final I_Object exec(CurProc cp, I_Object blockIT) throws ReturnException {
        cp = cp.copyCall(cp.call, true);
        return this.iExec(cp, blockIT)[0];
    }

    public I_Object execFunction(CurProc cpOld, Function f) throws ReturnException {
        boolean throw_return;
        I_Object checkValue;
        I_Object returnValue;
        CurProc cpNew;
        block10: {
            cpNew = cpOld.copy(cpOld.call, cpOld.instance.getMainEnv(), true);
            this.iInitPars(cpOld, cpNew, f.gVars(), cpOld.call.getPars(cpOld, null, null));
            returnValue = null;
            checkValue = null;
            throw_return = false;
            try {
                checkValue = returnValue = this.iExec(cpNew, Nil.NIL)[0];
            }
            catch (ReturnException e) {
                Return r = e.get();
                returnValue = r;
                checkValue = r.getResult();
                throw_return = true;
                if (r.getLevel() == Return.LEVEL.RETURN) break block10;
                Err.todo(r);
            }
        }
        if (checkValue == null && this.isEmpty()) {
            checkValue = returnValue = Lib_AtomConv.getDefaultValue(f.gReturnType());
        }
        if (f.gReturnType() != null) {
            if (f.gReturnType().equals("Same")) {
                if (throw_return && checkValue != Nil.NIL && !(checkValue instanceof MC_THIS) && !(checkValue instanceof Instance)) {
                    throw new CodeError(cpNew, "Wrong Value for Return-Type 'Same'", "Got \"" + checkValue.getClass().getSimpleName() + "\", need _THIS");
                }
                A_Object newValue = cpNew.instance;
                if (cpNew.instance instanceof App) {
                    newValue = new MC_THIS(cpNew.getType());
                }
                returnValue = throw_return ? new Return(((Return)returnValue).getLevel(), newValue) : newValue;
            } else if (!f.gReturnType().equals(checkValue.getTypeName())) {
                throw new CodeError(cpNew, "Wrong Return-Type", "Got \"" + returnValue.getClass().getSimpleName() + "\", need \"" + f.gReturnType() + "\"");
            }
        }
        if (throw_return) {
            throw new ReturnException((Return)returnValue);
        }
        return returnValue;
    }

    public void execTypeBlock(CurProc cpOld, CurProc cpNew1, I_Object[] pars) {
        CurProc cpNew2 = cpNew1.copyCall(cpNew1.call, false);
        this.iInitPars(cpOld, cpNew2, cpNew1.instance.getType().getVars(), pars);
        try {
            this.iExec(cpNew2, null);
        }
        catch (ReturnException e) {
            throw new CodeError(cpOld, "Invalid condition", "Return, Break & Continue in Type-Body is forbidden.");
        }
    }

    public ConstManager gConstManager() {
        return this.consts;
    }

    public Function getFunction() {
        return this.func;
    }

    public I_Object gIT() {
        return this.blockIT;
    }

    public Collection<Call> gItems() {
        return this.items;
    }

    public Block gParent() {
        return this.parent;
    }

    public Type gType() {
        return this.typ;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.size() == 0;
    }

    public VarManager gVarManager() {
        return this.vars;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "<Block_" + this.nr + ">";
    }

    @Override
    public String toString() {
        return "Block_" + this.nr;
    }

    private final I_Object[] iExec(CurProc cp, I_Object blockIT) throws ReturnException {
        this.blockIT = blockIT;
        if (this.items == null) {
            return new I_Object[2];
        }
        I_Object last_result = null;
        for (Call c : this.items) {
            I_Object result;
            last_result = result = c.exec(cp, blockIT);
            if (!(result instanceof Return)) continue;
            if (((Return)result).getLevel() != Return.LEVEL.EXIT) {
                throw new ReturnException((Return)result);
            }
            result = ((Return)result).getResult();
            cp.getApp().exit(cp.copyCall(new Call(cp.getSurrBlock(), result, cp.getDebugInfo()), false));
        }
        return new I_Object[]{this.blockIT, last_result};
    }

    private void iInitPars(CurProc cpOld, CurProc cpNew, FunctionPar[] fVCs, I_Object[] pars) {
        if (fVCs != null) {
            Err.ifNull(new Object[]{pars});
            int i = 0;
            while (i < fVCs.length) {
                I_Object par;
                boolean useDefault;
                FunctionPar fPar = fVCs[i];
                boolean bl = useDefault = pars.length < i + 1;
                if (useDefault && fPar.defaultValue == null) {
                    throw new CodeError(cpOld, "Missing parameter or default value", "Got " + pars.length + ", need " + fVCs.length + " parameter(s).");
                }
                I_Object i_Object = par = useDefault ? fPar.defaultValue : Lib_Convert.getValue(cpOld, pars[i]);
                if (fPar.type != null && !par.getTypeName().equals(fPar.type)) {
                    throw new CodeError(cpOld, "Wrong type of parameter", "Got " + par.getTypeName() + ", need " + fPar.type);
                }
                if (fPar.isConst) {
                    Const con = (Const)this.consts.use(fPar.name);
                    con.set(cpOld, cpNew, par);
                } else {
                    Var var = (Var)this.vars.use(fPar.name);
                    var.set(cpOld, cpNew, par);
                }
                ++i;
            }
        }
    }
}

